(function(HA,ZA){typeof exports=="object"&&typeof module<"u"?ZA(exports):typeof define=="function"&&define.amd?define(["exports"],ZA):(HA=typeof globalThis<"u"?globalThis:HA||self,ZA(HA.FCOSOrchidJudge={}))})(this,(function(HA){"use strict";class ZA{constructor(A){this.widget=A}render(){const A=this.widget.getConfig();return`
      <div class="space-y-6">
        <!-- Educational Disclaimer -->
        <div class="card bg-amber-50 dark:bg-amber-900/20 border-amber-200 dark:border-amber-800">
          <div class="flex items-start gap-3">
            <div class="text-amber-600 dark:text-amber-400 mt-1">⚠️</div>
            <div>
              <h3 class="font-semibold text-amber-800 dark:text-amber-200 mb-1">Educational Tool Only</h3>
              <p class="text-sm text-amber-700 dark:text-amber-300">
                This judging system is for educational and practice purposes only. 
                It does not provide official awards from any recognized orchid organization.
              </p>
            </div>
          </div>
        </div>

        <!-- Cloud Status -->
        ${!!(A.cloud?.webappUrl&&A.cloud?.secret)?"":`
          <div class="card bg-amber-50 dark:bg-amber-900/20 border-amber-200 dark:border-amber-800">
            <div class="text-sm text-amber-700 dark:text-amber-300">
              <strong>Cloud sync disabled</strong> — add EXPO_PUBLIC_FCOS_SHEETS_WEBAPP_URL and EXPO_PUBLIC_FCOS_SHEETS_SECRET to enable
            </div>
          </div>
        `}

        <!-- Main Navigation Cards -->
        <div class="grid grid-cols-1 gap-4">
          <!-- Profile / ID -->
          <div class="nav-card-green" data-nav="profile">
            <div class="flex items-center gap-3">
              <div class="w-10 h-10 bg-primary-100 dark:bg-primary-800 rounded-lg flex items-center justify-center">
                <span class="text-primary-600 dark:text-primary-400">👤</span>
              </div>
              <div>
                <h3 class="font-semibold text-gray-900 dark:text-white">Profile / ID</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">Configure settings and AI provider</p>
              </div>
            </div>
          </div>

          <!-- Start New Entry -->
          <div class="nav-card-purple" data-nav="capture">
            <div class="flex items-center gap-3">
              <div class="w-10 h-10 bg-secondary-100 dark:bg-secondary-800 rounded-lg flex items-center justify-center">
                <span class="text-secondary-600 dark:text-secondary-400">📷</span>
              </div>
              <div>
                <h3 class="font-semibold text-gray-900 dark:text-white">Start New Entry</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">Capture photos and begin judging</p>
              </div>
            </div>
          </div>

          <!-- View My Last 10 -->
          <div class="nav-card" data-nav="entries">
            <div class="flex items-center gap-3">
              <div class="w-10 h-10 bg-gray-100 dark:bg-gray-800 rounded-lg flex items-center justify-center">
                <span class="text-gray-600 dark:text-gray-400">📋</span>
              </div>
              <div>
                <h3 class="font-semibold text-gray-900 dark:text-white">View My Last 10</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">Recent judging entries</p>
              </div>
            </div>
          </div>

          <!-- How to Use -->
          <div class="nav-card" data-nav="howto">
            <div class="flex items-center gap-3">
              <div class="w-10 h-10 bg-gray-100 dark:bg-gray-800 rounded-lg flex items-center justify-center">
                <span class="text-gray-600 dark:text-gray-400">❓</span>
              </div>
              <div>
                <h3 class="font-semibold text-gray-900 dark:text-white">How to Use</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">Step-by-step guide</p>
              </div>
            </div>
          </div>

          <!-- FAQ -->
          <div class="nav-card" data-nav="faq">
            <div class="flex items-center gap-3">
              <div class="w-10 h-10 bg-gray-100 dark:bg-gray-800 rounded-lg flex items-center justify-center">
                <span class="text-gray-600 dark:text-gray-400">💬</span>
              </div>
              <div>
                <h3 class="font-semibold text-gray-900 dark:text-white">FAQ</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">Frequently asked questions</p>
              </div>
            </div>
          </div>

          <!-- About -->
          <div class="nav-card" data-nav="about">
            <div class="flex items-center gap-3">
              <div class="w-10 h-10 bg-gray-100 dark:bg-gray-800 rounded-lg flex items-center justify-center">
                <span class="text-gray-600 dark:text-gray-400">ℹ️</span>
              </div>
              <div>
                <h3 class="font-semibold text-gray-900 dark:text-white">About</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">FCOS mission and disclaimers</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    `}mount(A){A.querySelectorAll("[data-nav]").forEach(t=>{t.addEventListener("click",()=>{const s=t.getAttribute("data-nav");s&&this.widget.navigateTo(s)})})}}class un{dbName="fcos_orchid_judge";dbVersion=1;db=null;async init(){if(!("indexedDB"in window)){console.warn("IndexedDB not available, falling back to localStorage");return}return new Promise((A,e)=>{const t=indexedDB.open(this.dbName,this.dbVersion);t.onerror=()=>e(t.error),t.onsuccess=()=>{this.db=t.result,A()},t.onupgradeneeded=s=>{const n=s.target.result;n.objectStoreNames.contains("entries")||n.createObjectStore("entries",{keyPath:"id"}).createIndex("timestamp","timestamp",{unique:!1}),n.objectStoreNames.contains("profile")||n.createObjectStore("profile",{keyPath:"id"})}})}isAvailable(){return"indexedDB"in window||"localStorage"in window}async saveEntry(A){if(this.db)return new Promise((e,t)=>{const a=this.db.transaction(["entries"],"readwrite").objectStore("entries").put(A);a.onsuccess=()=>e(),a.onerror=()=>t(a.error)});{const e=this.getEntriesFromLocalStorage(),t=e.findIndex(s=>s.id===A.id);t>=0?e[t]=A:e.push(A),localStorage.setItem("fcos_orchid_judge_entries",JSON.stringify(e))}}async getEntries(A=10){return this.db?new Promise((e,t)=>{const B=this.db.transaction(["entries"],"readonly").objectStore("entries").index("timestamp").openCursor(null,"prev"),i=[];let o=0;B.onsuccess=c=>{const l=c.target.result;l&&o<A?(i.push(l.value),o++,l.continue()):e(i)},B.onerror=()=>t(B.error)}):this.getEntriesFromLocalStorage().sort((t,s)=>new Date(s.timestamp).getTime()-new Date(t.timestamp).getTime()).slice(0,A)}async getEntry(A){return this.db?new Promise((e,t)=>{const a=this.db.transaction(["entries"],"readonly").objectStore("entries").get(A);a.onsuccess=()=>e(a.result||null),a.onerror=()=>t(a.error)}):this.getEntriesFromLocalStorage().find(t=>t.id===A)||null}saveProfile(A){this.db?this.db.transaction(["profile"],"readwrite").objectStore("profile").put({id:"default",...A}):localStorage.setItem("fcos_orchid_judge_profile",JSON.stringify(A))}getProfile(){if(this.db){const A=localStorage.getItem("fcos_orchid_judge_profile");return A?JSON.parse(A):null}else{const A=localStorage.getItem("fcos_orchid_judge_profile");return A?JSON.parse(A):null}}getEntriesFromLocalStorage(){const A=localStorage.getItem("fcos_orchid_judge_entries");return A?JSON.parse(A):[]}async clearAll(){if(this.db)return new Promise((A,e)=>{const t=this.db.transaction(["entries","profile"],"readwrite");t.objectStore("entries").clear(),t.objectStore("profile").clear(),t.oncomplete=()=>A(),t.onerror=()=>e(t.error)});localStorage.removeItem("fcos_orchid_judge_entries"),localStorage.removeItem("fcos_orchid_judge_profile")}}const TA=new un;TA.init().catch(console.error);class wn{constructor(A){this.widget=A}render(){const A=this.loadProfile(),e=this.widget.getConfig();return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">Profile & Settings</h2>
        </div>

        <!-- Profile Form -->
        <div class="card space-y-4">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Personal Information</h3>
          
          <div>
            <label class="label">Name</label>
            <input type="text" class="input" id="profile-name" value="${A.name}" placeholder="Your name">
          </div>
          
          <div>
            <label class="label">Email (optional)</label>
            <input type="email" class="input" id="profile-email" value="${A.email}" placeholder="your.email@example.com">
          </div>
          
          <div>
            <label class="label">Language</label>
            <select class="input" id="profile-language">
              <option value="en" ${A.language==="en"?"selected":""}>English</option>
              <option value="ja" ${A.language==="ja"?"selected":""}>Japanese</option>
            </select>
          </div>
        </div>

        <!-- AI Provider Settings -->
        <div class="card space-y-4">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white">AI Provider</h3>
          
          <div>
            <label class="label">Provider</label>
            <select class="input" id="ai-provider">
              <option value="openai" ${A.aiProvider==="openai"?"selected":""}>OpenAI</option>
              <option value="webhook" ${A.aiProvider==="webhook"?"selected":""}>Custom Webhook</option>
            </select>
          </div>
          
          <div id="webhook-url-container" class="${A.aiProvider==="webhook"?"":"hidden"}">
            <label class="label">Webhook URL</label>
            <input type="url" class="input" id="webhook-url" value="${A.webhookUrl||""}" 
                   placeholder="https://your-api.com/analyze">
          </div>
          
          <div class="flex gap-2">
            <button class="btn btn-outline" data-action="test-ai">Test Connection</button>
            <button class="btn btn-outline" data-action="diagnostics">Run Diagnostics</button>
          </div>
          
          <div id="connection-status" class="text-sm"></div>
        </div>

        <!-- App Settings -->
        <div class="card space-y-4">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white">App Settings</h3>
          
          <div class="flex items-center justify-between">
            <div>
              <label class="label mb-0">Tutorial Mode</label>
              <p class="text-sm text-gray-600 dark:text-gray-400">Show helpful tips and guidance</p>
            </div>
            <input type="checkbox" id="tutorial-enabled" ${A.tutorialEnabled?"checked":""} 
                   class="w-5 h-5 text-primary-600 rounded border-gray-300 focus:ring-primary-500">
          </div>
          
          <div class="flex items-center justify-between">
            <div>
              <label class="label mb-0">Cloud Sync</label>
              <p class="text-sm text-gray-600 dark:text-gray-400">
                ${e.cloud?.webappUrl?"Auto-upload entries to cloud":"Not configured"}
              </p>
            </div>
            <input type="checkbox" id="cloud-sync-enabled" ${A.cloudSyncEnabled?"checked":""} 
                   ${e.cloud?.webappUrl?"":"disabled"}
                   class="w-5 h-5 text-primary-600 rounded border-gray-300 focus:ring-primary-500">
          </div>
        </div>

        <!-- Save Button -->
        <button class="btn btn-primary w-full" data-action="save">Save Profile</button>
      </div>
    `}mount(A){const e=A.querySelector('[data-action="back"]'),t=A.querySelector('[data-action="save"]'),s=A.querySelector('[data-action="test-ai"]'),n=A.querySelector('[data-action="diagnostics"]'),a=A.querySelector("#ai-provider"),B=A.querySelector("#webhook-url-container");e?.addEventListener("click",()=>this.widget.goBack()),t?.addEventListener("click",()=>this.saveProfile(A)),s?.addEventListener("click",()=>this.testAiConnection(A)),n?.addEventListener("click",()=>this.runDiagnostics(A)),a?.addEventListener("change",()=>{const i=a.value==="webhook";B?.classList.toggle("hidden",!i)})}loadProfile(){return TA.getProfile()||{name:"",email:"",language:"en",aiProvider:"openai",tutorialEnabled:!0,cloudSyncEnabled:!1}}saveProfile(A){const e={name:A.querySelector("#profile-name").value,email:A.querySelector("#profile-email").value,language:A.querySelector("#profile-language").value,aiProvider:A.querySelector("#ai-provider").value,webhookUrl:A.querySelector("#webhook-url").value,tutorialEnabled:A.querySelector("#tutorial-enabled").checked,cloudSyncEnabled:A.querySelector("#cloud-sync-enabled").checked};TA.saveProfile(e),this.showStatus(A,"Profile saved successfully!","success")}async testAiConnection(A){const e=this.loadProfile(),t=A.querySelector("#connection-status");t.innerHTML='<span class="text-blue-600">Testing connection...</span>';try{e.aiProvider==="openai"?(await fetch("https://api.openai.com/v1/models",{headers:{Authorization:`Bearer ${window.OPENAI_API_KEY||""}`}})).ok?t.innerHTML='<span class="text-green-600">✓ OpenAI connection successful</span>':t.innerHTML='<span class="text-red-600">✗ OpenAI connection failed - check API key</span>':(await fetch(e.webhookUrl||"",{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify({test:!0})})).ok?t.innerHTML='<span class="text-green-600">✓ Webhook connection successful</span>':t.innerHTML='<span class="text-red-600">✗ Webhook connection failed</span>'}catch{t.innerHTML='<span class="text-red-600">✗ Connection test failed</span>'}}async runDiagnostics(A){const e=A.querySelector("#connection-status");e.innerHTML=`
      <div class="space-y-2 text-sm">
        <div class="font-semibold">System Diagnostics:</div>
        <div>• Storage: ${TA.isAvailable()?"✓ Available":"✗ Not available"}</div>
        <div>• Camera: ${navigator.mediaDevices?"✓ Available":"✗ Not available"}</div>
        <div>• Cloud: ${this.widget.getConfig().cloud?.webappUrl?"✓ Configured":"✗ Not configured"}</div>
        <div>• Web Share: ${navigator.share?"✓ Available":"✗ Not available"}</div>
        <div>• File System: ${window.showSaveFilePicker?"✓ Available":"✗ Not available"}</div>
      </div>
    `}showStatus(A,e,t){const s=A.querySelector("#connection-status"),n=t==="success"?"text-green-600":"text-red-600";s.innerHTML=`<span class="${n}">${e}</span>`,setTimeout(()=>{s.innerHTML=""},3e3)}}class Qn{constructor(A){this.widget=A}currentEntry={};stream=null;render(){return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">Capture Photos</h2>
        </div>

        <!-- Educational Notice -->
        <div class="card bg-blue-50 dark:bg-blue-900/20 border-blue-200 dark:border-blue-800">
          <div class="flex items-start gap-3">
            <div class="text-blue-600 dark:text-blue-400 mt-1">ℹ️</div>
            <div>
              <h3 class="font-semibold text-blue-800 dark:text-blue-200 mb-1">Photo Tips</h3>
              <p class="text-sm text-blue-700 dark:text-blue-300">
                • Capture clear photos of the blooming plant<br>
                • Include the ID tag if available<br>
                • Good lighting improves analysis accuracy<br>
                • Include a ruler/card for size reference
              </p>
            </div>
          </div>
        </div>

        <!-- Photo Steps -->
        <div class="space-y-4">
          <!-- Step 1: Plant Photo -->
          <div class="card">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
              Step 1: Blooming Plant Photo
            </h3>
            
            <div id="plant-photo-section">
              ${this.currentEntry.photos?.plant?this.renderPhotoPreview("plant"):this.renderPhotoCapture("plant")}
            </div>
          </div>

          <!-- Step 2: ID Tag Photo (Optional) -->
          <div class="card">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
              Step 2: ID Tag Photo (Optional)
            </h3>
            
            <div id="tag-photo-section">
              ${this.currentEntry.photos?.tag?this.renderPhotoPreview("tag"):this.renderPhotoCapture("tag")}
            </div>
          </div>

          <!-- Continue Button -->
          <div class="pt-4">
            <button class="btn btn-primary w-full" data-action="continue" 
                    ${this.currentEntry.photos?.plant?"":"disabled"}>
              ${this.currentEntry.photos?.tag?"Continue to Tag Analysis":"Continue without Tag"}
            </button>
          </div>
        </div>
      </div>
    `}renderPhotoCapture(A){return`
      <div class="space-y-3">
        <div class="grid grid-cols-2 gap-3">
          <button class="btn btn-primary" data-action="camera" data-type="${A}">
            📷 Take Photo
          </button>
          <button class="btn btn-outline" data-action="library" data-type="${A}">
            🖼️ Photo Library
          </button>
        </div>
        
        <!-- Camera Preview (hidden initially) -->
        <div id="${A}-camera-section" class="hidden">
          <video id="${A}-video" class="w-full rounded-lg bg-gray-100 dark:bg-gray-800" autoplay playsinline></video>
          <div class="flex gap-2 mt-3">
            <button class="btn btn-primary flex-1" data-action="take-photo" data-type="${A}">
              📸 Capture
            </button>
            <button class="btn btn-outline" data-action="cancel-camera" data-type="${A}">
              Cancel
            </button>
          </div>
          <canvas id="${A}-canvas" class="hidden"></canvas>
        </div>
        
        <!-- File Input (hidden) -->
        <input type="file" id="${A}-file-input" accept="image/*" class="hidden">
      </div>
    `}renderPhotoPreview(A){return`
      <div class="space-y-3">
        <div class="relative">
          <img src="${A==="plant"?this.currentEntry.photos?.plant:this.currentEntry.photos?.tag}" alt="${A} photo" class="w-full rounded-lg">
          <button class="absolute top-2 right-2 btn btn-outline text-sm" data-action="retake" data-type="${A}">
            🔄 Retake
          </button>
        </div>
      </div>
    `}mount(A){const e=A.querySelector('[data-action="back"]'),t=A.querySelector('[data-action="continue"]');e?.addEventListener("click",()=>this.widget.goBack()),t?.addEventListener("click",()=>this.continueToAnalysis()),A.querySelectorAll('[data-action="camera"]').forEach(s=>{s.addEventListener("click",n=>{const a=n.target.dataset.type;this.startCamera(a,A)})}),A.querySelectorAll('[data-action="library"]').forEach(s=>{s.addEventListener("click",n=>{const a=n.target.dataset.type;this.openPhotoLibrary(a,A)})}),A.querySelectorAll('[data-action="take-photo"]').forEach(s=>{s.addEventListener("click",n=>{const a=n.target.dataset.type;this.takePhoto(a,A)})}),A.querySelectorAll('[data-action="cancel-camera"]').forEach(s=>{s.addEventListener("click",n=>{const a=n.target.dataset.type;this.cancelCamera(a,A)})}),A.querySelectorAll('[data-action="retake"]').forEach(s=>{s.addEventListener("click",n=>{const a=n.target.dataset.type;this.retakePhoto(a,A)})})}async startCamera(A,e){try{const t={video:{facingMode:"environment",width:{ideal:1280},height:{ideal:720}}};this.stream=await navigator.mediaDevices.getUserMedia(t);const s=e.querySelector(`#${A}-video`),n=e.querySelector(`#${A}-camera-section`);s&&n&&(s.srcObject=this.stream,n.classList.remove("hidden"))}catch(t){console.error("Camera access failed:",t),alert("Camera access failed. Please check permissions and try again.")}}takePhoto(A,e){const t=e.querySelector(`#${A}-video`),s=e.querySelector(`#${A}-canvas`);if(t&&s){const n=s.getContext("2d");s.width=t.videoWidth,s.height=t.videoHeight,n?.drawImage(t,0,0);const a=s.toDataURL("image/jpeg",.8);this.savePhoto(A,a),this.cancelCamera(A,e),this.updatePhotoSection(A,e)}}cancelCamera(A,e){this.stream&&(this.stream.getTracks().forEach(s=>s.stop()),this.stream=null),e.querySelector(`#${A}-camera-section`)?.classList.add("hidden")}openPhotoLibrary(A,e){const t=e.querySelector(`#${A}-file-input`);t.onchange=s=>{const n=s.target.files?.[0];if(n){const a=new FileReader;a.onload=B=>{const i=B.target?.result;this.savePhoto(A,i),this.updatePhotoSection(A,e)},a.readAsDataURL(n)}},t.click()}savePhoto(A,e){this.currentEntry.photos||(this.currentEntry.photos={plant:""}),A==="plant"?this.currentEntry.photos.plant=e:this.currentEntry.photos.tag=e}retakePhoto(A,e){A==="plant"?this.currentEntry.photos.plant="":this.currentEntry.photos.tag="",this.updatePhotoSection(A,e)}updatePhotoSection(A,e){const t=e.querySelector(`#${A}-photo-section`);if(t){const n=A==="plant"?this.currentEntry.photos?.plant:this.currentEntry.photos?.tag;t.innerHTML=n?this.renderPhotoPreview(A):this.renderPhotoCapture(A),this.attachSectionListeners(t,A,e)}const s=e.querySelector('[data-action="continue"]');s&&(s.disabled=!this.currentEntry.photos?.plant,s.textContent=this.currentEntry.photos?.tag?"Continue to Tag Analysis":"Continue without Tag")}attachSectionListeners(A,e,t){A.querySelectorAll('[data-action="camera"]').forEach(s=>{s.addEventListener("click",()=>this.startCamera(e,t))}),A.querySelectorAll('[data-action="library"]').forEach(s=>{s.addEventListener("click",()=>this.openPhotoLibrary(e,t))}),A.querySelectorAll('[data-action="take-photo"]').forEach(s=>{s.addEventListener("click",()=>this.takePhoto(e,t))}),A.querySelectorAll('[data-action="cancel-camera"]').forEach(s=>{s.addEventListener("click",()=>this.cancelCamera(e,t))}),A.querySelectorAll('[data-action="retake"]').forEach(s=>{s.addEventListener("click",()=>this.retakePhoto(e,t))})}continueToAnalysis(){this.currentEntry.id=this.generateId(),this.currentEntry.timestamp=new Date().toISOString(),this.widget.navigateTo("analysis",this.currentEntry)}generateId(){return"entry_"+Date.now()+"_"+Math.random().toString(36).substr(2,9)}destroy(){this.stream&&(this.stream.getTracks().forEach(A=>A.stop()),this.stream=null)}}class dn{constructor(A){this.widget=A}render(){return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">My Last 10 Entries</h2>
        </div>

        <!-- Loading State -->
        <div id="entries-loading" class="text-center py-8">
          <div class="text-gray-500 dark:text-gray-400">Loading entries...</div>
        </div>

        <!-- Entries List -->
        <div id="entries-list" class="space-y-4 hidden">
          <!-- Entries will be populated here -->
        </div>

        <!-- Empty State -->
        <div id="entries-empty" class="text-center py-12 hidden">
          <div class="text-gray-500 dark:text-gray-400 mb-4">
            📋 No entries yet
          </div>
          <p class="text-sm text-gray-400 dark:text-gray-500 mb-6">
            Start your first orchid judging session to see entries here
          </p>
          <button class="btn btn-primary" data-action="start-new">
            Start New Entry
          </button>
        </div>
      </div>
    `}async mount(A){const e=A.querySelector('[data-action="back"]'),t=A.querySelector('[data-action="start-new"]');e?.addEventListener("click",()=>this.widget.goBack()),t?.addEventListener("click",()=>this.widget.navigateTo("capture")),await this.loadEntries(A)}async loadEntries(A){const e=A.querySelector("#entries-loading"),t=A.querySelector("#entries-list"),s=A.querySelector("#entries-empty");try{const n=await TA.getEntries(10);e?.classList.add("hidden"),n.length===0?s?.classList.remove("hidden"):(t.innerHTML=n.map(a=>this.renderEntry(a)).join(""),t?.classList.remove("hidden"),t?.querySelectorAll('[data-action="view-entry"]').forEach(a=>{a.addEventListener("click",B=>{const i=B.target.dataset.entryId;i&&this.viewEntry(i)})}))}catch(n){console.error("Failed to load entries:",n),e.innerHTML=`
        <div class="text-red-500 dark:text-red-400">
          Failed to load entries. Please try again.
        </div>
      `}}renderEntry(A){const e=new Date(A.timestamp).toLocaleDateString(),t=new Date(A.timestamp).toLocaleTimeString([],{hour:"2-digit",minute:"2-digit"}),s=this.getDisplayName(A),n=this.getBandClass(A.scoring.band);let a=0;return A.photos.plant&&a++,A.photos.tag&&a++,A.certificate?.png&&a++,`
      <div class="card hover:shadow-md transition-shadow cursor-pointer" 
           data-action="view-entry" data-entry-id="${A.id}">
        <div class="flex items-start gap-4">
          <!-- Thumbnail -->
          <div class="w-16 h-16 rounded-lg overflow-hidden bg-gray-100 dark:bg-gray-800 flex-shrink-0">
            ${A.photos.plant?`<img src="${A.photos.plant}" alt="Orchid" class="w-full h-full object-cover">`:'<div class="w-full h-full flex items-center justify-center text-gray-400">📷</div>'}
          </div>
          
          <!-- Content -->
          <div class="flex-1 min-w-0">
            <div class="flex items-start justify-between gap-2 mb-2">
              <h3 class="font-semibold text-gray-900 dark:text-white truncate">
                ${s}
              </h3>
              <span class="text-sm px-2 py-1 rounded-full ${n} flex-shrink-0">
                ${A.scoring.weightedTotal}/100
              </span>
            </div>
            
            <div class="flex items-center gap-4 text-sm text-gray-600 dark:text-gray-400 mb-2">
              <span>🏆 AOS (Educational)</span>
              <span>📅 ${e}</span>
              <span>🕒 ${t}</span>
            </div>
            
            <div class="flex items-center justify-between">
              <span class="text-xs px-2 py-1 rounded ${n}">
                ${A.scoring.band}
              </span>
              
              <div class="flex items-center gap-2 text-xs text-gray-500 dark:text-gray-400">
                ${a>0?`<span>📎 ${a}</span>`:""}
                <span class="text-green-600 dark:text-green-400">●</span>
                <span>Completed</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    `}getDisplayName(A){const{genus:e,speciesOrGrex:t,clone:s}=A.ocr;if(!e&&!t)return"Unnamed Orchid";let n=e||"Unknown";return t&&(n+=" "+t),s&&(n+=` '${s}'`),n}getBandClass(A){switch(A){case"Excellence (educational)":return"score-band-excellence";case"Distinction (educational)":return"score-band-distinction";case"Commended (educational)":return"score-band-commended";default:return"score-band-none"}}async viewEntry(A){try{const e=await TA.getEntry(A);e&&this.widget.navigateTo("certificate",e)}catch(e){console.error("Failed to load entry:",e),alert("Failed to load entry. Please try again.")}}}class fn{constructor(A){this.widget=A}render(A){if(!A)return`
        <div class="text-center py-8">
          <div class="text-gray-500 dark:text-gray-400">No entry data available</div>
          <button class="btn btn-outline mt-4" data-action="back">← Back</button>
        </div>
      `;const e=this.getDisplayName(A),t=new Date(A.timestamp).toLocaleDateString(),s=this.getBandClass(A.scoring.band);return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">Certificate</h2>
        </div>

        <!-- Certificate Display -->
        <div id="certificate-content" class="card">
          <!-- Header Section -->
          <div class="text-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">
              FCOS Orchid Judge
            </h1>
            <p class="text-sm text-gray-600 dark:text-gray-400">
              Educational Judging Certificate
            </p>
          </div>

          <!-- Orchid Info -->
          <div class="border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">
            <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-2">
              ${e}
            </h2>
            <div class="grid grid-cols-2 gap-4 text-sm">
              <div>
                <span class="text-gray-600 dark:text-gray-400">Genus:</span>
                <span class="ml-2 text-gray-900 dark:text-white">${A.ocr.genus||"Unknown"}</span>
              </div>
              <div>
                <span class="text-gray-600 dark:text-gray-400">Species/Grex:</span>
                <span class="ml-2 text-gray-900 dark:text-white">${A.ocr.speciesOrGrex||"Unknown"}</span>
              </div>
              ${A.ocr.clone?`
                <div class="col-span-2">
                  <span class="text-gray-600 dark:text-gray-400">Clone:</span>
                  <span class="ml-2 text-gray-900 dark:text-white">'${A.ocr.clone}'</span>
                </div>
              `:""}
            </div>
          </div>

          <!-- Metrics Panel -->
          <div class="grid grid-cols-3 gap-4 mb-6">
            <div class="text-center">
              <div class="text-2xl font-bold text-primary-600 dark:text-primary-400">
                ${A.analysis.spikeCount}
              </div>
              <div class="text-sm text-gray-600 dark:text-gray-400">Spike Count</div>
            </div>
            <div class="text-center">
              <div class="text-2xl font-bold text-primary-600 dark:text-primary-400">
                ${A.analysis.symmetryPct}%
              </div>
              <div class="text-sm text-gray-600 dark:text-gray-400">Symmetry</div>
            </div>
            <div class="text-center">
              <div class="text-2xl font-bold text-primary-600 dark:text-primary-400">
                ${A.analysis.naturalSpreadCm}cm
              </div>
              <div class="text-sm text-gray-600 dark:text-gray-400">Natural Spread</div>
            </div>
          </div>

          <!-- Scoring Results -->
          <div class="mb-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
              Educational Scoring Results
            </h3>
            
            <div class="text-center mb-4">
              <div class="text-4xl font-bold text-gray-900 dark:text-white">
                ${A.scoring.weightedTotal}/100
              </div>
              <div class="text-lg px-4 py-2 rounded-full inline-block mt-2 ${s}">
                ${A.scoring.band}
              </div>
            </div>

            <!-- Detailed Scores -->
            <div class="space-y-2 text-sm">
              ${this.renderScoreBreakdown(A)}
            </div>
          </div>

          <!-- Footer -->
          <div class="text-center pt-4 border-t border-gray-200 dark:border-gray-700">
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-1">
              Five Cities Orchid Society — Learn · Grow · Share
            </p>
            <p class="text-xs text-gray-500 dark:text-gray-500">
              Generated on ${t} • Educational purposes only
            </p>
          </div>
        </div>

        <!-- Export Actions -->
        <div class="space-y-4">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
            Export Options
          </h3>
          
          <div class="grid grid-cols-2 gap-3">
            <button class="btn btn-primary" data-action="export-png">
              📄 Certificate PNG
            </button>
            <button class="btn btn-outline" data-action="export-csv">
              📊 Score Report CSV
            </button>
            <button class="btn btn-outline" data-action="export-narrative">
              📝 Narrative TXT
            </button>
            <button class="btn btn-outline" data-action="export-hybrid">
              🧬 Hybrid Report TXT
            </button>
          </div>

          <!-- Email & Share -->
          <div class="card bg-gray-50 dark:bg-gray-800">
            <h4 class="font-medium text-gray-900 dark:text-white mb-3">
              Share Results
            </h4>
            <div class="space-y-3">
              <input type="email" class="input" id="share-email" 
                     placeholder="Email address (optional)">
              <div class="flex gap-2">
                <button class="btn btn-primary flex-1" data-action="share">
                  📧 Share
                </button>
                <button class="btn btn-outline" data-action="save-entry">
                  💾 Save Entry
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    `}renderScoreBreakdown(A){return[{key:"form",label:"Form / Symmetry / Balance"},{key:"color",label:"Color & Saturation"},{key:"size",label:"Size / Substance"},{key:"floriferousness",label:"Floriferousness & Arrangement"},{key:"condition",label:"Condition & Grooming"},{key:"distinctiveness",label:"Distinctiveness / Impression"}].map(t=>{const s=A.scoring.weights[t.key],n=A.scoring.raw[t.key],a=Math.round(n/100*s);return`
        <div class="flex justify-between items-center">
          <span class="text-gray-700 dark:text-gray-300">${t.label}</span>
          <div class="text-right">
            <span class="text-gray-900 dark:text-white font-medium">${a}/${s}</span>
            <span class="text-gray-500 dark:text-gray-400 ml-2">(${n}/100)</span>
          </div>
        </div>
      `}).join("")}getDisplayName(A){const{genus:e,speciesOrGrex:t,clone:s}=A.ocr;if(!e&&!t)return"Unnamed Orchid";let n=e||"Unknown";return t&&(n+=" "+t),s&&(n+=` '${s}'`),n}getBandClass(A){switch(A){case"Excellence (educational)":return"score-band-excellence";case"Distinction (educational)":return"score-band-distinction";case"Commended (educational)":return"score-band-commended";default:return"score-band-none"}}mount(A){A.querySelector('[data-action="back"]')?.addEventListener("click",()=>this.widget.goBack()),A.querySelector('[data-action="export-png"]')?.addEventListener("click",()=>this.exportPNG()),A.querySelector('[data-action="export-csv"]')?.addEventListener("click",()=>this.exportCSV()),A.querySelector('[data-action="export-narrative"]')?.addEventListener("click",()=>this.exportNarrative()),A.querySelector('[data-action="export-hybrid"]')?.addEventListener("click",()=>this.exportHybrid()),A.querySelector('[data-action="share"]')?.addEventListener("click",()=>this.shareResults()),A.querySelector('[data-action="save-entry"]')?.addEventListener("click",()=>this.saveEntry())}async exportPNG(){try{const A=(await Promise.resolve().then(()=>Wc)).default,e=document.querySelector("#certificate-content");if(!e)return;const t=await A(e,{backgroundColor:"#ffffff",scale:2,useCORS:!0}),s=document.createElement("a");s.download=`orchid-certificate-${Date.now()}.png`,s.href=t.toDataURL(),s.click()}catch(A){console.error("Failed to export PNG:",A),alert("Failed to export certificate. Please try again.")}}exportCSV(){alert("CSV export functionality coming soon!")}exportNarrative(){alert("Narrative export functionality coming soon!")}exportHybrid(){alert("Hybrid report export functionality coming soon!")}shareResults(){alert("Share functionality coming soon!")}saveEntry(){alert("Entry saved successfully!")}}class Cn{constructor(A){this.widget=A}render(){return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">How to Use</h2>
        </div>

        <!-- Introduction -->
        <div class="card bg-blue-50 dark:bg-blue-900/20 border-blue-200 dark:border-blue-800">
          <h3 class="font-semibold text-blue-800 dark:text-blue-200 mb-2">
            Welcome to FCOS Orchid Judge
          </h3>
          <p class="text-sm text-blue-700 dark:text-blue-300">
            Follow these steps to create educational orchid judging entries. 
            This tool is designed for learning and practice purposes only.
          </p>
        </div>

        <!-- Steps -->
        <div class="space-y-4">
          ${this.renderStep(1,"📷","Capture Photos","Take clear photos of your blooming orchid and ID tag (if available)","capture")}
          
          ${this.renderStep(2,"🏷️","Read the Tag","OCR extracts genus/species/grex/clone information from ID tags automatically","capture")}
          
          ${this.renderStep(3,"📚","Registry Lookup","Optional lookup of parentage and awards from RHS/AOS databases",null)}
          
          ${this.renderStep(4,"🔍","Image Analysis","AI analyzes flower counts, symmetry, and measurements with manual editing",null)}
          
          ${this.renderStep(5,"⭐","Educational Scoring","Score using weighted educational rubric with instant band results",null)}
          
          ${this.renderStep(6,"📤","Export & Cloud","Generate certificates (PNG), reports (CSV/TXT) with optional cloud sync",null)}
          
          ${this.renderStep(7,"📋","History & Certificates","Review past entries and generate professional certificates","entries")}
          
          ${this.renderStep(8,"🔒","Tips & Privacy","Data stays on your device unless cloud sync is enabled",null)}
        </div>

        <!-- Quick Start -->
        <div class="card bg-primary-50 dark:bg-primary-900/20 border-primary-200 dark:border-primary-800">
          <h3 class="font-semibold text-primary-800 dark:text-primary-200 mb-3">
            Ready to Begin?
          </h3>
          <button class="btn btn-primary w-full" data-action="quick-start">
            Start Your First Entry
          </button>
        </div>
      </div>
    `}renderStep(A,e,t,s,n){return`
      <div class="card">
        <div class="flex items-start gap-4">
          <div class="w-10 h-10 bg-primary-100 dark:bg-primary-800 rounded-full flex items-center justify-center flex-shrink-0">
            <span class="text-lg">${e}</span>
          </div>
          
          <div class="flex-1">
            <div class="flex items-center justify-between mb-2">
              <h3 class="font-semibold text-gray-900 dark:text-white">
                ${A}. ${t}
              </h3>
              ${n?`
                <button class="btn btn-outline btn-sm" data-action="step" data-step="${n}">
                  Start
                </button>
              `:""}
            </div>
            
            <p class="text-sm text-gray-600 dark:text-gray-400">
              ${s}
            </p>
          </div>
        </div>
      </div>
    `}mount(A){const e=A.querySelector('[data-action="back"]'),t=A.querySelector('[data-action="quick-start"]');e?.addEventListener("click",()=>this.widget.goBack()),t?.addEventListener("click",()=>this.widget.navigateTo("capture")),A.querySelectorAll('[data-action="step"]').forEach(s=>{s.addEventListener("click",n=>{const a=n.target.dataset.step;a&&this.widget.navigateTo(a)})})}}class hn{constructor(A){this.widget=A}render(){return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">Frequently Asked Questions</h2>
        </div>

        <!-- FAQ Items -->
        <div class="space-y-2">
          ${[{question:"How is Form / Symmetry / Balance scored?",answer:"Form scoring evaluates the overall shape, symmetry, and balance of the flower. Points are awarded for well-proportioned petals, proper flower positioning, and bilateral symmetry. Educational scoring helps you understand ideal orchid characteristics."},{question:"How is Color & Saturation scored?",answer:"Color scoring assesses the intensity, clarity, and appeal of flower colors. Vibrant, clear colors with good contrast typically score higher. The AI analyzes color distribution and saturation levels across the bloom."},{question:"How is Size & Substance scored?",answer:"Size considers flower dimensions relative to the species standard, while substance evaluates the thickness and quality of petals and sepals. Flowers with good substance appear fuller and more durable."},{question:"How is Floriferousness & Arrangement scored?",answer:"This category evaluates the number of flowers, spike quality, and overall presentation. More flowers arranged well on strong spikes typically score higher. The arrangement should be balanced and attractive."},{question:"How is Condition & Grooming scored?",answer:"Condition scoring looks at the health and freshness of the flowers, while grooming considers plant cleanliness and presentation. Fresh, unblemished flowers on clean plants score best."},{question:"How is Distinctiveness / Impression scored?",answer:"This subjective category rewards exceptional characteristics that make the orchid stand out. Unique color patterns, unusual forms, or exceptional quality can earn high distinctiveness scores."},{question:"Is this official judging?",answer:"No, this is an educational tool only. It does not provide official awards from AOS, AOC, RHS, or any recognized orchid organization. Results are for learning and practice purposes only."},{question:"Do my photos upload automatically?",answer:"Photos stay on your device by default. Cloud sync only occurs if you enable it in Profile settings and provide the required cloud configuration. You have full control over your data."},{question:"What is Hybrid Analysis?",answer:"Hybrid analysis identifies grex names (hybrid group names) and attempts to lookup parentage information. When available, it provides breeding history and related awards to help understand the hybrid's background."},{question:"How do I export my results?",answer:"From any entry, you can export certificates as PNG images, detailed scoring as CSV files, or narrative reports as TXT files. Use the share button to email or save results to your device."},{question:"Can I track progress over multiple years?",answer:"Yes! The app maintains a history of your entries, allowing you to track improvements and compare results over time. Your data persists on your device until you clear it or the app is uninstalled."}].map((e,t)=>this.renderFAQItem(e,t)).join("")}
        </div>

        <!-- Additional Help -->
        <div class="card bg-gray-50 dark:bg-gray-800">
          <h3 class="font-semibold text-gray-900 dark:text-white mb-2">
            Need More Help?
          </h3>
          <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
            This tool is provided by the Five Cities Orchid Society for educational purposes. 
            For technical support or questions about orchid care, visit our website or contact local orchid societies.
          </p>
          <div class="flex gap-2">
            <button class="btn btn-outline btn-sm" data-action="about">
              About FCOS
            </button>
            <button class="btn btn-outline btn-sm" data-action="profile">
              Run Diagnostics
            </button>
          </div>
        </div>
      </div>
    `}renderFAQItem(A,e){return`
      <div class="card">
        <button class="w-full text-left" data-action="toggle-faq" data-index="${e}">
          <div class="flex items-center justify-between">
            <h3 class="font-medium text-gray-900 dark:text-white pr-4">
              ${A.question}
            </h3>
            <span class="faq-icon text-gray-400 transform transition-transform duration-200">
              ▼
            </span>
          </div>
        </button>
        
        <div class="faq-answer hidden mt-3 pt-3 border-t border-gray-200 dark:border-gray-700">
          <p class="text-sm text-gray-600 dark:text-gray-400">
            ${A.answer}
          </p>
        </div>
      </div>
    `}mount(A){const e=A.querySelector('[data-action="back"]'),t=A.querySelector('[data-action="about"]'),s=A.querySelector('[data-action="profile"]');e?.addEventListener("click",()=>this.widget.goBack()),t?.addEventListener("click",()=>this.widget.navigateTo("about")),s?.addEventListener("click",()=>this.widget.navigateTo("profile")),A.querySelectorAll('[data-action="toggle-faq"]').forEach(n=>{n.addEventListener("click",a=>{const i=a.currentTarget.closest(".card"),o=i?.querySelector(".faq-answer"),c=i?.querySelector(".faq-icon");o&&c&&(o.classList.contains("hidden")?(o.classList.remove("hidden"),c.classList.add("rotate-180")):(o.classList.add("hidden"),c.classList.remove("rotate-180")))})})}}class Un{constructor(A){this.widget=A}render(){return`
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">About</h2>
        </div>

        <!-- Educational Tool Badge -->
        <div class="text-center">
          <div class="inline-block px-4 py-2 bg-blue-100 dark:bg-blue-900/30 text-blue-800 dark:text-blue-200 rounded-full text-sm font-medium mb-4">
            Educational Tool (Beta)
          </div>
        </div>

        <!-- FCOS Mission -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Five Cities Orchid Society Mission
          </h3>
          <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
            The Five Cities Orchid Society is dedicated to promoting the appreciation, 
            cultivation, and conservation of orchids through education, research, and community engagement. 
            We believe in making orchid knowledge accessible to everyone, from beginners to experts.
          </p>
        </div>

        <!-- Features -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Widget Features
          </h3>
          <div class="space-y-2 text-sm">
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Mobile-first responsive design</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">AI-powered image analysis and OCR</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Multiple international judging systems</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Comprehensive entry history and tracking</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Offline-first with optional cloud sync</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Professional certificate generation</span>
            </div>
          </div>
        </div>

        <!-- Important Disclaimer -->
        <div class="card bg-amber-50 dark:bg-amber-900/20 border-amber-200 dark:border-amber-800">
          <div class="flex items-start gap-3">
            <div class="text-amber-600 dark:text-amber-400 mt-1 text-lg">⚠️</div>
            <div>
              <h3 class="font-semibold text-amber-800 dark:text-amber-200 mb-2">
                Important Disclaimer
              </h3>
              <div class="text-sm text-amber-700 dark:text-amber-300 space-y-2">
                <p>
                  <strong>This is an educational tool for practice and learning purposes only.</strong>
                </p>
                <p>
                  This application is not affiliated with, endorsed by, or approved by the American Orchid Society (AOS), 
                  Australian Orchid Council (AOC), Orchid Society of New Zealand (OSNZ), Royal Horticultural Society (RHS), 
                  or any other official orchid judging organization.
                </p>
                <p>
                  Results, scores, and awards generated by this tool are for educational practice only and 
                  have no official recognition or validity for actual orchid judging competitions.
                </p>
                <p>
                  For official orchid judging, please contact your local orchid society or 
                  authorized judging centers recognized by official organizations.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Version & Technical Info -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Technical Information
          </h3>
          <div class="text-sm text-gray-600 dark:text-gray-400 space-y-1">
            <div class="flex justify-between">
              <span>Version:</span>
              <span>1.0.0 (Beta)</span>
            </div>
            <div class="flex justify-between">
              <span>Last Updated:</span>
              <span>${new Date().toLocaleDateString()}</span>
            </div>
            <div class="flex justify-between">
              <span>Data Storage:</span>
              <span>Local Device + Optional Cloud</span>
            </div>
            <div class="flex justify-between">
              <span>AI Provider:</span>
              <span id="ai-provider-display">Configurable</span>
            </div>
          </div>
        </div>

        <!-- Contact & Learn More -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Learn More
          </h3>
          <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
            Interested in learning more about orchids or joining our community? 
            Connect with the Five Cities Orchid Society and other orchid enthusiasts.
          </p>
          <div class="flex gap-2">
            <button class="btn btn-outline btn-sm" data-action="how-to">
              How to Use
            </button>
            <button class="btn btn-outline btn-sm" data-action="faq">
              FAQ
            </button>
          </div>
        </div>

        <!-- Footer -->
        <div class="text-center text-xs text-gray-500 dark:text-gray-400 py-4 border-t border-gray-200 dark:border-gray-700">
          Five Cities Orchid Society — Learn · Grow · Share<br>
          Educational Widget © ${new Date().getFullYear()}
        </div>
      </div>
    `}mount(A){const e=A.querySelector('[data-action="back"]'),t=A.querySelector('[data-action="how-to"]'),s=A.querySelector('[data-action="faq"]');e?.addEventListener("click",()=>this.widget.goBack()),t?.addEventListener("click",()=>this.widget.navigateTo("howto")),s?.addEventListener("click",()=>this.widget.navigateTo("faq")),this.updateAIProviderDisplay(A)}updateAIProviderDisplay(A){const e=A.querySelector("#ai-provider-display"),t=this.widget.getConfig();e&&(e.textContent=t.aiProvider.mode==="openai"?"OpenAI":"Custom Webhook")}}class Br{container;config;viewState;views;constructor(A,e){this.container=A,this.config=e,this.viewState={currentView:"home"},this.views=new Map,this.initializeWidget(),this.initializeViews(),this.applyTheme(),this.render()}initializeWidget(){this.container.className=`fcos-orchid-judge ${this.config.theme} ${this.config.largeText?"large-text":""}`,this.container.innerHTML=`
      <div class="widget-container">
        <div id="fcos-header" class="sticky top-0 z-10 bg-white dark:bg-gray-900 border-b border-gray-200 dark:border-gray-700 px-4 py-3">
          <div class="flex items-center justify-between">
            <h1 class="text-xl font-bold text-gray-900 dark:text-white">FCOS Orchid Judge</h1>
            <div class="flex gap-2">
              <button id="theme-toggle" class="btn btn-outline text-xs">
                ${this.config.theme==="dark"?"☀️":"🌙"}
              </button>
              <button id="text-size-toggle" class="btn btn-outline text-xs">
                Aa ${this.config.largeText?"Normal":"Large"}
              </button>
            </div>
          </div>
        </div>
        <div id="fcos-content" class="px-4 py-6"></div>
        <div id="fcos-footer" class="px-4 py-3 border-t border-gray-200 dark:border-gray-700 text-center text-xs text-gray-500">
          Five Cities Orchid Society — Learn · Grow · Share
        </div>
      </div>
    `,this.setupEventListeners()}initializeViews(){this.views.set("home",new ZA(this)),this.views.set("profile",new wn(this)),this.views.set("capture",new Qn(this)),this.views.set("entries",new dn(this)),this.views.set("certificate",new fn(this)),this.views.set("howto",new Cn(this)),this.views.set("faq",new hn(this)),this.views.set("about",new Un(this))}setupEventListeners(){const A=this.container.querySelector("#theme-toggle"),e=this.container.querySelector("#text-size-toggle");A?.addEventListener("click",()=>{this.config.theme=this.config.theme==="dark"?"light":"dark",this.applyTheme(),this.updateHeader()}),e?.addEventListener("click",()=>{this.config.largeText=!this.config.largeText,this.applyTextSize(),this.updateHeader()})}applyTheme(){this.config.theme==="dark"?this.container.classList.add("dark"):this.container.classList.remove("dark")}applyTextSize(){this.config.largeText?this.container.classList.add("large-text"):this.container.classList.remove("large-text")}updateHeader(){const A=this.container.querySelector("#theme-toggle"),e=this.container.querySelector("#text-size-toggle");A&&(A.textContent=this.config.theme==="dark"?"☀️":"🌙"),e&&(e.textContent=`Aa ${this.config.largeText?"Normal":"Large"}`)}render(){const A=this.container.querySelector("#fcos-content");if(!A)return;const e=this.views.get(this.viewState.currentView);e&&(A.innerHTML=e.render(this.viewState.data),e.mount?.(A))}navigateTo(A,e){this.viewState.previousView=this.viewState.currentView,this.viewState.currentView=A,this.viewState.data=e,this.render()}goBack(){this.viewState.previousView?this.navigateTo(this.viewState.previousView):this.navigateTo("home")}getConfig(){return this.config}updateConfig(A){this.config={...this.config,...A},this.applyTheme(),this.applyTextSize(),this.updateHeader()}destroy(){this.container.innerHTML="",this.views.clear()}}const or={mount(r,A={}){const e=document.querySelector(r);if(!e)throw new Error(`FCOS Orchid Judge: Container not found for selector "${r}"`);const s={...{theme:"light",largeText:!1,cloud:{webappUrl:window.EXPO_PUBLIC_FCOS_SHEETS_WEBAPP_URL||void 0,secret:window.EXPO_PUBLIC_FCOS_SHEETS_SECRET||void 0},aiProvider:{mode:"openai",webhookUrl:void 0},language:"en"},...A};return new Br(e,s)},unmount(r){r.destroy()}};typeof window<"u"&&(window.FCOSOrchidJudge=or);/*!
 * html2canvas 1.4.1 <https://html2canvas.hertzen.com>
 * Copyright (c) 2022 Niklas von Hertzen <https://hertzen.com>
 * Released under MIT License
 *//*! *****************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */var lt=function(r,A){return lt=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&(e[s]=t[s])},lt(r,A)};function tA(r,A){if(typeof A!="function"&&A!==null)throw new TypeError("Class extends value "+String(A)+" is not a constructor or null");lt(r,A);function e(){this.constructor=r}r.prototype=A===null?Object.create(A):(e.prototype=A.prototype,new e)}var gt=function(){return gt=Object.assign||function(A){for(var e,t=1,s=arguments.length;t<s;t++){e=arguments[t];for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(A[n]=e[n])}return A},gt.apply(this,arguments)};function X(r,A,e,t){function s(n){return n instanceof e?n:new e(function(a){a(n)})}return new(e||(e=Promise))(function(n,a){function B(c){try{o(t.next(c))}catch(l){a(l)}}function i(c){try{o(t.throw(c))}catch(l){a(l)}}function o(c){c.done?n(c.value):s(c.value).then(B,i)}o((t=t.apply(r,[])).next())})}function P(r,A){var e={label:0,sent:function(){if(n[0]&1)throw n[1];return n[1]},trys:[],ops:[]},t,s,n,a;return a={next:B(0),throw:B(1),return:B(2)},typeof Symbol=="function"&&(a[Symbol.iterator]=function(){return this}),a;function B(o){return function(c){return i([o,c])}}function i(o){if(t)throw new TypeError("Generator is already executing.");for(;e;)try{if(t=1,s&&(n=o[0]&2?s.return:o[0]?s.throw||((n=s.return)&&n.call(s),0):s.next)&&!(n=n.call(s,o[1])).done)return n;switch(s=0,n&&(o=[o[0]&2,n.value]),o[0]){case 0:case 1:n=o;break;case 4:return e.label++,{value:o[1],done:!1};case 5:e.label++,s=o[1],o=[0];continue;case 7:o=e.ops.pop(),e.trys.pop();continue;default:if(n=e.trys,!(n=n.length>0&&n[n.length-1])&&(o[0]===6||o[0]===2)){e=0;continue}if(o[0]===3&&(!n||o[1]>n[0]&&o[1]<n[3])){e.label=o[1];break}if(o[0]===6&&e.label<n[1]){e.label=n[1],n=o;break}if(n&&e.label<n[2]){e.label=n[2],e.ops.push(o);break}n[2]&&e.ops.pop(),e.trys.pop();continue}o=A.call(r,e)}catch(c){o=[6,c],s=0}finally{t=n=0}if(o[0]&5)throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}}function Ce(r,A,e){if(arguments.length===2)for(var t=0,s=A.length,n;t<s;t++)(n||!(t in A))&&(n||(n=Array.prototype.slice.call(A,0,t)),n[t]=A[t]);return r.concat(n||A)}for(var BA=(function(){function r(A,e,t,s){this.left=A,this.top=e,this.width=t,this.height=s}return r.prototype.add=function(A,e,t,s){return new r(this.left+A,this.top+e,this.width+t,this.height+s)},r.fromClientRect=function(A,e){return new r(e.left+A.windowBounds.left,e.top+A.windowBounds.top,e.width,e.height)},r.fromDOMRectList=function(A,e){var t=Array.from(e).find(function(s){return s.width!==0});return t?new r(t.left+A.windowBounds.left,t.top+A.windowBounds.top,t.width,t.height):r.EMPTY},r.EMPTY=new r(0,0,0,0),r})(),he=function(r,A){return BA.fromClientRect(r,A.getBoundingClientRect())},Fn=function(r){var A=r.body,e=r.documentElement;if(!A||!e)throw new Error("Unable to get document size");var t=Math.max(Math.max(A.scrollWidth,e.scrollWidth),Math.max(A.offsetWidth,e.offsetWidth),Math.max(A.clientWidth,e.clientWidth)),s=Math.max(Math.max(A.scrollHeight,e.scrollHeight),Math.max(A.offsetHeight,e.offsetHeight),Math.max(A.clientHeight,e.clientHeight));return new BA(0,0,t,s)},Ue=function(r){for(var A=[],e=0,t=r.length;e<t;){var s=r.charCodeAt(e++);if(s>=55296&&s<=56319&&e<t){var n=r.charCodeAt(e++);(n&64512)===56320?A.push(((s&1023)<<10)+(n&1023)+65536):(A.push(s),e--)}else A.push(s)}return A},D=function(){for(var r=[],A=0;A<arguments.length;A++)r[A]=arguments[A];if(String.fromCodePoint)return String.fromCodePoint.apply(String,r);var e=r.length;if(!e)return"";for(var t=[],s=-1,n="";++s<e;){var a=r[s];a<=65535?t.push(a):(a-=65536,t.push((a>>10)+55296,a%1024+56320)),(s+1===e||t.length>16384)&&(n+=String.fromCharCode.apply(String,t),t.length=0)}return n},cr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",pn=typeof Uint8Array>"u"?[]:new Uint8Array(256),Fe=0;Fe<cr.length;Fe++)pn[cr.charCodeAt(Fe)]=Fe;for(var lr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",qA=typeof Uint8Array>"u"?[]:new Uint8Array(256),pe=0;pe<lr.length;pe++)qA[lr.charCodeAt(pe)]=pe;for(var vn=function(r){var A=r.length*.75,e=r.length,t,s=0,n,a,B,i;r[r.length-1]==="="&&(A--,r[r.length-2]==="="&&A--);var o=typeof ArrayBuffer<"u"&&typeof Uint8Array<"u"&&typeof Uint8Array.prototype.slice<"u"?new ArrayBuffer(A):new Array(A),c=Array.isArray(o)?o:new Uint8Array(o);for(t=0;t<e;t+=4)n=qA[r.charCodeAt(t)],a=qA[r.charCodeAt(t+1)],B=qA[r.charCodeAt(t+2)],i=qA[r.charCodeAt(t+3)],c[s++]=n<<2|a>>4,c[s++]=(a&15)<<4|B>>2,c[s++]=(B&3)<<6|i&63;return o},En=function(r){for(var A=r.length,e=[],t=0;t<A;t+=2)e.push(r[t+1]<<8|r[t]);return e},Hn=function(r){for(var A=r.length,e=[],t=0;t<A;t+=4)e.push(r[t+3]<<24|r[t+2]<<16|r[t+1]<<8|r[t]);return e},yA=5,ut=11,wt=2,yn=ut-yA,gr=65536>>yA,mn=1<<yA,Qt=mn-1,In=1024>>yA,bn=gr+In,xn=bn,Ln=32,Kn=xn+Ln,Sn=65536>>ut,Dn=1<<yn,Tn=Dn-1,ur=function(r,A,e){return r.slice?r.slice(A,e):new Uint16Array(Array.prototype.slice.call(r,A,e))},On=function(r,A,e){return r.slice?r.slice(A,e):new Uint32Array(Array.prototype.slice.call(r,A,e))},Mn=function(r,A){var e=vn(r),t=Array.isArray(e)?Hn(e):new Uint32Array(e),s=Array.isArray(e)?En(e):new Uint16Array(e),n=24,a=ur(s,n/2,t[4]/2),B=t[5]===2?ur(s,(n+t[4])/2):On(t,Math.ceil((n+t[4])/4));return new Gn(t[0],t[1],t[2],t[3],a,B)},Gn=(function(){function r(A,e,t,s,n,a){this.initialValue=A,this.errorValue=e,this.highStart=t,this.highValueIndex=s,this.index=n,this.data=a}return r.prototype.get=function(A){var e;if(A>=0){if(A<55296||A>56319&&A<=65535)return e=this.index[A>>yA],e=(e<<wt)+(A&Qt),this.data[e];if(A<=65535)return e=this.index[gr+(A-55296>>yA)],e=(e<<wt)+(A&Qt),this.data[e];if(A<this.highStart)return e=Kn-Sn+(A>>ut),e=this.index[e],e+=A>>yA&Tn,e=this.index[e],e=(e<<wt)+(A&Qt),this.data[e];if(A<=1114111)return this.data[this.highValueIndex]}return this.errorValue},r})(),wr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",kn=typeof Uint8Array>"u"?[]:new Uint8Array(256),ve=0;ve<wr.length;ve++)kn[wr.charCodeAt(ve)]=ve;var Rn="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",Qr=50,Vn=1,dr=2,fr=3,Nn=4,Pn=5,Cr=7,hr=8,Ur=9,wA=10,dt=11,Fr=12,ft=13,_n=14,jA=15,Ct=16,Ee=17,$A=18,Xn=19,pr=20,ht=21,zA=22,Ut=23,OA=24,q=25,Ae=26,ee=27,MA=28,Jn=29,mA=30,Wn=31,He=32,ye=33,Ft=34,pt=35,vt=36,te=37,Et=38,me=39,Ie=40,Ht=41,vr=42,Yn=43,Zn=[9001,65288],Er="!",H="×",be="÷",yt=Mn(Rn),oA=[mA,vt],mt=[Vn,dr,fr,Pn],Hr=[wA,hr],yr=[ee,Ae],qn=mt.concat(Hr),mr=[Et,me,Ie,Ft,pt],jn=[jA,ft],$n=function(r,A){A===void 0&&(A="strict");var e=[],t=[],s=[];return r.forEach(function(n,a){var B=yt.get(n);if(B>Qr?(s.push(!0),B-=Qr):s.push(!1),["normal","auto","loose"].indexOf(A)!==-1&&[8208,8211,12316,12448].indexOf(n)!==-1)return t.push(a),e.push(Ct);if(B===Nn||B===dt){if(a===0)return t.push(a),e.push(mA);var i=e[a-1];return qn.indexOf(i)===-1?(t.push(t[a-1]),e.push(i)):(t.push(a),e.push(mA))}if(t.push(a),B===Wn)return e.push(A==="strict"?ht:te);if(B===vr||B===Jn)return e.push(mA);if(B===Yn)return n>=131072&&n<=196605||n>=196608&&n<=262141?e.push(te):e.push(mA);e.push(B)}),[t,e,s]},It=function(r,A,e,t){var s=t[e];if(Array.isArray(r)?r.indexOf(s)!==-1:r===s)for(var n=e;n<=t.length;){n++;var a=t[n];if(a===A)return!0;if(a!==wA)break}if(s===wA)for(var n=e;n>0;){n--;var B=t[n];if(Array.isArray(r)?r.indexOf(B)!==-1:r===B)for(var i=e;i<=t.length;){i++;var a=t[i];if(a===A)return!0;if(a!==wA)break}if(B!==wA)break}return!1},Ir=function(r,A){for(var e=r;e>=0;){var t=A[e];if(t===wA)e--;else return t}return 0},zn=function(r,A,e,t,s){if(e[t]===0)return H;var n=t-1;if(Array.isArray(s)&&s[n]===!0)return H;var a=n-1,B=n+1,i=A[n],o=a>=0?A[a]:0,c=A[B];if(i===dr&&c===fr)return H;if(mt.indexOf(i)!==-1)return Er;if(mt.indexOf(c)!==-1||Hr.indexOf(c)!==-1)return H;if(Ir(n,A)===hr)return be;if(yt.get(r[n])===dt||(i===He||i===ye)&&yt.get(r[B])===dt||i===Cr||c===Cr||i===Ur||[wA,ft,jA].indexOf(i)===-1&&c===Ur||[Ee,$A,Xn,OA,MA].indexOf(c)!==-1||Ir(n,A)===zA||It(Ut,zA,n,A)||It([Ee,$A],ht,n,A)||It(Fr,Fr,n,A))return H;if(i===wA)return be;if(i===Ut||c===Ut)return H;if(c===Ct||i===Ct)return be;if([ft,jA,ht].indexOf(c)!==-1||i===_n||o===vt&&jn.indexOf(i)!==-1||i===MA&&c===vt||c===pr||oA.indexOf(c)!==-1&&i===q||oA.indexOf(i)!==-1&&c===q||i===ee&&[te,He,ye].indexOf(c)!==-1||[te,He,ye].indexOf(i)!==-1&&c===Ae||oA.indexOf(i)!==-1&&yr.indexOf(c)!==-1||yr.indexOf(i)!==-1&&oA.indexOf(c)!==-1||[ee,Ae].indexOf(i)!==-1&&(c===q||[zA,jA].indexOf(c)!==-1&&A[B+1]===q)||[zA,jA].indexOf(i)!==-1&&c===q||i===q&&[q,MA,OA].indexOf(c)!==-1)return H;if([q,MA,OA,Ee,$A].indexOf(c)!==-1)for(var l=n;l>=0;){var g=A[l];if(g===q)return H;if([MA,OA].indexOf(g)!==-1)l--;else break}if([ee,Ae].indexOf(c)!==-1)for(var l=[Ee,$A].indexOf(i)!==-1?a:n;l>=0;){var g=A[l];if(g===q)return H;if([MA,OA].indexOf(g)!==-1)l--;else break}if(Et===i&&[Et,me,Ft,pt].indexOf(c)!==-1||[me,Ft].indexOf(i)!==-1&&[me,Ie].indexOf(c)!==-1||[Ie,pt].indexOf(i)!==-1&&c===Ie||mr.indexOf(i)!==-1&&[pr,Ae].indexOf(c)!==-1||mr.indexOf(c)!==-1&&i===ee||oA.indexOf(i)!==-1&&oA.indexOf(c)!==-1||i===OA&&oA.indexOf(c)!==-1||oA.concat(q).indexOf(i)!==-1&&c===zA&&Zn.indexOf(r[B])===-1||oA.concat(q).indexOf(c)!==-1&&i===$A)return H;if(i===Ht&&c===Ht){for(var f=e[n],u=1;f>0&&(f--,A[f]===Ht);)u++;if(u%2!==0)return H}return i===He&&c===ye?H:be},Aa=function(r,A){A||(A={lineBreak:"normal",wordBreak:"normal"});var e=$n(r,A.lineBreak),t=e[0],s=e[1],n=e[2];(A.wordBreak==="break-all"||A.wordBreak==="break-word")&&(s=s.map(function(B){return[q,mA,vr].indexOf(B)!==-1?te:B}));var a=A.wordBreak==="keep-all"?n.map(function(B,i){return B&&r[i]>=19968&&r[i]<=40959}):void 0;return[t,s,a]},ea=(function(){function r(A,e,t,s){this.codePoints=A,this.required=e===Er,this.start=t,this.end=s}return r.prototype.slice=function(){return D.apply(void 0,this.codePoints.slice(this.start,this.end))},r})(),ta=function(r,A){var e=Ue(r),t=Aa(e,A),s=t[0],n=t[1],a=t[2],B=e.length,i=0,o=0;return{next:function(){if(o>=B)return{done:!0,value:null};for(var c=H;o<B&&(c=zn(e,n,s,++o,a))===H;);if(c!==H||o===B){var l=new ea(e,c,i,o);return i=o,{value:l,done:!1}}return{done:!0,value:null}}}},ra=1,sa=2,re=4,br=8,xe=10,xr=47,se=92,na=9,aa=32,Le=34,ne=61,ia=35,Ba=36,oa=37,Ke=39,Se=40,ae=41,ca=95,J=45,la=33,ga=60,ua=62,wa=64,Qa=91,da=93,fa=61,Ca=123,De=63,ha=125,Lr=124,Ua=126,Fa=128,Kr=65533,bt=42,IA=43,pa=44,va=58,Ea=59,ie=46,Ha=0,ya=8,ma=11,Ia=14,ba=31,xa=127,sA=-1,Sr=48,Dr=97,Tr=101,La=102,Ka=117,Sa=122,Or=65,Mr=69,Gr=70,Da=85,Ta=90,_=function(r){return r>=Sr&&r<=57},Oa=function(r){return r>=55296&&r<=57343},GA=function(r){return _(r)||r>=Or&&r<=Gr||r>=Dr&&r<=La},Ma=function(r){return r>=Dr&&r<=Sa},Ga=function(r){return r>=Or&&r<=Ta},ka=function(r){return Ma(r)||Ga(r)},Ra=function(r){return r>=Fa},Te=function(r){return r===xe||r===na||r===aa},Oe=function(r){return ka(r)||Ra(r)||r===ca},kr=function(r){return Oe(r)||_(r)||r===J},Va=function(r){return r>=Ha&&r<=ya||r===ma||r>=Ia&&r<=ba||r===xa},QA=function(r,A){return r!==se?!1:A!==xe},Me=function(r,A,e){return r===J?Oe(A)||QA(A,e):Oe(r)?!0:!!(r===se&&QA(r,A))},xt=function(r,A,e){return r===IA||r===J?_(A)?!0:A===ie&&_(e):_(r===ie?A:r)},Na=function(r){var A=0,e=1;(r[A]===IA||r[A]===J)&&(r[A]===J&&(e=-1),A++);for(var t=[];_(r[A]);)t.push(r[A++]);var s=t.length?parseInt(D.apply(void 0,t),10):0;r[A]===ie&&A++;for(var n=[];_(r[A]);)n.push(r[A++]);var a=n.length,B=a?parseInt(D.apply(void 0,n),10):0;(r[A]===Mr||r[A]===Tr)&&A++;var i=1;(r[A]===IA||r[A]===J)&&(r[A]===J&&(i=-1),A++);for(var o=[];_(r[A]);)o.push(r[A++]);var c=o.length?parseInt(D.apply(void 0,o),10):0;return e*(s+B*Math.pow(10,-a))*Math.pow(10,i*c)},Pa={type:2},_a={type:3},Xa={type:4},Ja={type:13},Wa={type:8},Ya={type:21},Za={type:9},qa={type:10},ja={type:11},$a={type:12},za={type:14},Ge={type:23},Ai={type:1},ei={type:25},ti={type:24},ri={type:26},si={type:27},ni={type:28},ai={type:29},ii={type:31},Lt={type:32},Rr=(function(){function r(){this._value=[]}return r.prototype.write=function(A){this._value=this._value.concat(Ue(A))},r.prototype.read=function(){for(var A=[],e=this.consumeToken();e!==Lt;)A.push(e),e=this.consumeToken();return A},r.prototype.consumeToken=function(){var A=this.consumeCodePoint();switch(A){case Le:return this.consumeStringToken(Le);case ia:var e=this.peekCodePoint(0),t=this.peekCodePoint(1),s=this.peekCodePoint(2);if(kr(e)||QA(t,s)){var n=Me(e,t,s)?sa:ra,a=this.consumeName();return{type:5,value:a,flags:n}}break;case Ba:if(this.peekCodePoint(0)===ne)return this.consumeCodePoint(),Ja;break;case Ke:return this.consumeStringToken(Ke);case Se:return Pa;case ae:return _a;case bt:if(this.peekCodePoint(0)===ne)return this.consumeCodePoint(),za;break;case IA:if(xt(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case pa:return Xa;case J:var B=A,i=this.peekCodePoint(0),o=this.peekCodePoint(1);if(xt(B,i,o))return this.reconsumeCodePoint(A),this.consumeNumericToken();if(Me(B,i,o))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();if(i===J&&o===ua)return this.consumeCodePoint(),this.consumeCodePoint(),ti;break;case ie:if(xt(A,this.peekCodePoint(0),this.peekCodePoint(1)))return this.reconsumeCodePoint(A),this.consumeNumericToken();break;case xr:if(this.peekCodePoint(0)===bt)for(this.consumeCodePoint();;){var c=this.consumeCodePoint();if(c===bt&&(c=this.consumeCodePoint(),c===xr))return this.consumeToken();if(c===sA)return this.consumeToken()}break;case va:return ri;case Ea:return si;case ga:if(this.peekCodePoint(0)===la&&this.peekCodePoint(1)===J&&this.peekCodePoint(2)===J)return this.consumeCodePoint(),this.consumeCodePoint(),ei;break;case wa:var l=this.peekCodePoint(0),g=this.peekCodePoint(1),f=this.peekCodePoint(2);if(Me(l,g,f)){var a=this.consumeName();return{type:7,value:a}}break;case Qa:return ni;case se:if(QA(A,this.peekCodePoint(0)))return this.reconsumeCodePoint(A),this.consumeIdentLikeToken();break;case da:return ai;case fa:if(this.peekCodePoint(0)===ne)return this.consumeCodePoint(),Wa;break;case Ca:return ja;case ha:return $a;case Ka:case Da:var u=this.peekCodePoint(0),w=this.peekCodePoint(1);return u===IA&&(GA(w)||w===De)&&(this.consumeCodePoint(),this.consumeUnicodeRangeToken()),this.reconsumeCodePoint(A),this.consumeIdentLikeToken();case Lr:if(this.peekCodePoint(0)===ne)return this.consumeCodePoint(),Za;if(this.peekCodePoint(0)===Lr)return this.consumeCodePoint(),Ya;break;case Ua:if(this.peekCodePoint(0)===ne)return this.consumeCodePoint(),qa;break;case sA:return Lt}return Te(A)?(this.consumeWhiteSpace(),ii):_(A)?(this.reconsumeCodePoint(A),this.consumeNumericToken()):Oe(A)?(this.reconsumeCodePoint(A),this.consumeIdentLikeToken()):{type:6,value:D(A)}},r.prototype.consumeCodePoint=function(){var A=this._value.shift();return typeof A>"u"?-1:A},r.prototype.reconsumeCodePoint=function(A){this._value.unshift(A)},r.prototype.peekCodePoint=function(A){return A>=this._value.length?-1:this._value[A]},r.prototype.consumeUnicodeRangeToken=function(){for(var A=[],e=this.consumeCodePoint();GA(e)&&A.length<6;)A.push(e),e=this.consumeCodePoint();for(var t=!1;e===De&&A.length<6;)A.push(e),e=this.consumeCodePoint(),t=!0;if(t){var s=parseInt(D.apply(void 0,A.map(function(i){return i===De?Sr:i})),16),n=parseInt(D.apply(void 0,A.map(function(i){return i===De?Gr:i})),16);return{type:30,start:s,end:n}}var a=parseInt(D.apply(void 0,A),16);if(this.peekCodePoint(0)===J&&GA(this.peekCodePoint(1))){this.consumeCodePoint(),e=this.consumeCodePoint();for(var B=[];GA(e)&&B.length<6;)B.push(e),e=this.consumeCodePoint();var n=parseInt(D.apply(void 0,B),16);return{type:30,start:a,end:n}}else return{type:30,start:a,end:a}},r.prototype.consumeIdentLikeToken=function(){var A=this.consumeName();return A.toLowerCase()==="url"&&this.peekCodePoint(0)===Se?(this.consumeCodePoint(),this.consumeUrlToken()):this.peekCodePoint(0)===Se?(this.consumeCodePoint(),{type:19,value:A}):{type:20,value:A}},r.prototype.consumeUrlToken=function(){var A=[];if(this.consumeWhiteSpace(),this.peekCodePoint(0)===sA)return{type:22,value:""};var e=this.peekCodePoint(0);if(e===Ke||e===Le){var t=this.consumeStringToken(this.consumeCodePoint());return t.type===0&&(this.consumeWhiteSpace(),this.peekCodePoint(0)===sA||this.peekCodePoint(0)===ae)?(this.consumeCodePoint(),{type:22,value:t.value}):(this.consumeBadUrlRemnants(),Ge)}for(;;){var s=this.consumeCodePoint();if(s===sA||s===ae)return{type:22,value:D.apply(void 0,A)};if(Te(s))return this.consumeWhiteSpace(),this.peekCodePoint(0)===sA||this.peekCodePoint(0)===ae?(this.consumeCodePoint(),{type:22,value:D.apply(void 0,A)}):(this.consumeBadUrlRemnants(),Ge);if(s===Le||s===Ke||s===Se||Va(s))return this.consumeBadUrlRemnants(),Ge;if(s===se)if(QA(s,this.peekCodePoint(0)))A.push(this.consumeEscapedCodePoint());else return this.consumeBadUrlRemnants(),Ge;else A.push(s)}},r.prototype.consumeWhiteSpace=function(){for(;Te(this.peekCodePoint(0));)this.consumeCodePoint()},r.prototype.consumeBadUrlRemnants=function(){for(;;){var A=this.consumeCodePoint();if(A===ae||A===sA)return;QA(A,this.peekCodePoint(0))&&this.consumeEscapedCodePoint()}},r.prototype.consumeStringSlice=function(A){for(var e=5e4,t="";A>0;){var s=Math.min(e,A);t+=D.apply(void 0,this._value.splice(0,s)),A-=s}return this._value.shift(),t},r.prototype.consumeStringToken=function(A){var e="",t=0;do{var s=this._value[t];if(s===sA||s===void 0||s===A)return e+=this.consumeStringSlice(t),{type:0,value:e};if(s===xe)return this._value.splice(0,t),Ai;if(s===se){var n=this._value[t+1];n!==sA&&n!==void 0&&(n===xe?(e+=this.consumeStringSlice(t),t=-1,this._value.shift()):QA(s,n)&&(e+=this.consumeStringSlice(t),e+=D(this.consumeEscapedCodePoint()),t=-1))}t++}while(!0)},r.prototype.consumeNumber=function(){var A=[],e=re,t=this.peekCodePoint(0);for((t===IA||t===J)&&A.push(this.consumeCodePoint());_(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0);var s=this.peekCodePoint(1);if(t===ie&&_(s))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=br;_(this.peekCodePoint(0));)A.push(this.consumeCodePoint());t=this.peekCodePoint(0),s=this.peekCodePoint(1);var n=this.peekCodePoint(2);if((t===Mr||t===Tr)&&((s===IA||s===J)&&_(n)||_(s)))for(A.push(this.consumeCodePoint(),this.consumeCodePoint()),e=br;_(this.peekCodePoint(0));)A.push(this.consumeCodePoint());return[Na(A),e]},r.prototype.consumeNumericToken=function(){var A=this.consumeNumber(),e=A[0],t=A[1],s=this.peekCodePoint(0),n=this.peekCodePoint(1),a=this.peekCodePoint(2);if(Me(s,n,a)){var B=this.consumeName();return{type:15,number:e,flags:t,unit:B}}return s===oa?(this.consumeCodePoint(),{type:16,number:e,flags:t}):{type:17,number:e,flags:t}},r.prototype.consumeEscapedCodePoint=function(){var A=this.consumeCodePoint();if(GA(A)){for(var e=D(A);GA(this.peekCodePoint(0))&&e.length<6;)e+=D(this.consumeCodePoint());Te(this.peekCodePoint(0))&&this.consumeCodePoint();var t=parseInt(e,16);return t===0||Oa(t)||t>1114111?Kr:t}return A===sA?Kr:A},r.prototype.consumeName=function(){for(var A="";;){var e=this.consumeCodePoint();if(kr(e))A+=D(e);else if(QA(e,this.peekCodePoint(0)))A+=D(this.consumeEscapedCodePoint());else return this.reconsumeCodePoint(e),A}},r})(),Vr=(function(){function r(A){this._tokens=A}return r.create=function(A){var e=new Rr;return e.write(A),new r(e.read())},r.parseValue=function(A){return r.create(A).parseComponentValue()},r.parseValues=function(A){return r.create(A).parseComponentValues()},r.prototype.parseComponentValue=function(){for(var A=this.consumeToken();A.type===31;)A=this.consumeToken();if(A.type===32)throw new SyntaxError("Error parsing CSS component value, unexpected EOF");this.reconsumeToken(A);var e=this.consumeComponentValue();do A=this.consumeToken();while(A.type===31);if(A.type===32)return e;throw new SyntaxError("Error parsing CSS component value, multiple values found when expecting only one")},r.prototype.parseComponentValues=function(){for(var A=[];;){var e=this.consumeComponentValue();if(e.type===32)return A;A.push(e),A.push()}},r.prototype.consumeComponentValue=function(){var A=this.consumeToken();switch(A.type){case 11:case 28:case 2:return this.consumeSimpleBlock(A.type);case 19:return this.consumeFunction(A)}return A},r.prototype.consumeSimpleBlock=function(A){for(var e={type:A,values:[]},t=this.consumeToken();;){if(t.type===32||oi(t,A))return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue()),t=this.consumeToken()}},r.prototype.consumeFunction=function(A){for(var e={name:A.value,values:[],type:18};;){var t=this.consumeToken();if(t.type===32||t.type===3)return e;this.reconsumeToken(t),e.values.push(this.consumeComponentValue())}},r.prototype.consumeToken=function(){var A=this._tokens.shift();return typeof A>"u"?Lt:A},r.prototype.reconsumeToken=function(A){this._tokens.unshift(A)},r})(),Be=function(r){return r.type===15},kA=function(r){return r.type===17},x=function(r){return r.type===20},Bi=function(r){return r.type===0},Kt=function(r,A){return x(r)&&r.value===A},Nr=function(r){return r.type!==31},RA=function(r){return r.type!==31&&r.type!==4},nA=function(r){var A=[],e=[];return r.forEach(function(t){if(t.type===4){if(e.length===0)throw new Error("Error parsing function args, zero tokens for arg");A.push(e),e=[];return}t.type!==31&&e.push(t)}),e.length&&A.push(e),A},oi=function(r,A){return A===11&&r.type===12||A===28&&r.type===29?!0:A===2&&r.type===3},dA=function(r){return r.type===17||r.type===15},O=function(r){return r.type===16||dA(r)},Pr=function(r){return r.length>1?[r[0],r[1]]:[r[0]]},R={type:17,number:0,flags:re},St={type:16,number:50,flags:re},fA={type:16,number:100,flags:re},oe=function(r,A,e){var t=r[0],s=r[1];return[K(t,A),K(typeof s<"u"?s:t,e)]},K=function(r,A){if(r.type===16)return r.number/100*A;if(Be(r))switch(r.unit){case"rem":case"em":return 16*r.number;case"px":default:return r.number}return r.number},_r="deg",Xr="grad",Jr="rad",Wr="turn",ke={name:"angle",parse:function(r,A){if(A.type===15)switch(A.unit){case _r:return Math.PI*A.number/180;case Xr:return Math.PI/200*A.number;case Jr:return A.number;case Wr:return Math.PI*2*A.number}throw new Error("Unsupported angle type")}},Yr=function(r){return r.type===15&&(r.unit===_r||r.unit===Xr||r.unit===Jr||r.unit===Wr)},Zr=function(r){var A=r.filter(x).map(function(e){return e.value}).join(" ");switch(A){case"to bottom right":case"to right bottom":case"left top":case"top left":return[R,R];case"to top":case"bottom":return $(0);case"to bottom left":case"to left bottom":case"right top":case"top right":return[R,fA];case"to right":case"left":return $(90);case"to top left":case"to left top":case"right bottom":case"bottom right":return[fA,fA];case"to bottom":case"top":return $(180);case"to top right":case"to right top":case"left bottom":case"bottom left":return[fA,R];case"to left":case"right":return $(270)}return 0},$=function(r){return Math.PI*r/180},CA={name:"color",parse:function(r,A){if(A.type===18){var e=ci[A.name];if(typeof e>"u")throw new Error('Attempting to parse an unsupported color function "'+A.name+'"');return e(r,A.values)}if(A.type===5){if(A.value.length===3){var t=A.value.substring(0,1),s=A.value.substring(1,2),n=A.value.substring(2,3);return UA(parseInt(t+t,16),parseInt(s+s,16),parseInt(n+n,16),1)}if(A.value.length===4){var t=A.value.substring(0,1),s=A.value.substring(1,2),n=A.value.substring(2,3),a=A.value.substring(3,4);return UA(parseInt(t+t,16),parseInt(s+s,16),parseInt(n+n,16),parseInt(a+a,16)/255)}if(A.value.length===6){var t=A.value.substring(0,2),s=A.value.substring(2,4),n=A.value.substring(4,6);return UA(parseInt(t,16),parseInt(s,16),parseInt(n,16),1)}if(A.value.length===8){var t=A.value.substring(0,2),s=A.value.substring(2,4),n=A.value.substring(4,6),a=A.value.substring(6,8);return UA(parseInt(t,16),parseInt(s,16),parseInt(n,16),parseInt(a,16)/255)}}if(A.type===20){var B=cA[A.value.toUpperCase()];if(typeof B<"u")return B}return cA.TRANSPARENT}},hA=function(r){return(255&r)===0},k=function(r){var A=255&r,e=255&r>>8,t=255&r>>16,s=255&r>>24;return A<255?"rgba("+s+","+t+","+e+","+A/255+")":"rgb("+s+","+t+","+e+")"},UA=function(r,A,e,t){return(r<<24|A<<16|e<<8|Math.round(t*255)<<0)>>>0},qr=function(r,A){if(r.type===17)return r.number;if(r.type===16){var e=A===3?1:255;return A===3?r.number/100*e:Math.round(r.number/100*e)}return 0},jr=function(r,A){var e=A.filter(RA);if(e.length===3){var t=e.map(qr),s=t[0],n=t[1],a=t[2];return UA(s,n,a,1)}if(e.length===4){var B=e.map(qr),s=B[0],n=B[1],a=B[2],i=B[3];return UA(s,n,a,i)}return 0};function Dt(r,A,e){return e<0&&(e+=1),e>=1&&(e-=1),e<1/6?(A-r)*e*6+r:e<1/2?A:e<2/3?(A-r)*6*(2/3-e)+r:r}var $r=function(r,A){var e=A.filter(RA),t=e[0],s=e[1],n=e[2],a=e[3],B=(t.type===17?$(t.number):ke.parse(r,t))/(Math.PI*2),i=O(s)?s.number/100:0,o=O(n)?n.number/100:0,c=typeof a<"u"&&O(a)?K(a,1):1;if(i===0)return UA(o*255,o*255,o*255,1);var l=o<=.5?o*(i+1):o+i-o*i,g=o*2-l,f=Dt(g,l,B+1/3),u=Dt(g,l,B),w=Dt(g,l,B-1/3);return UA(f*255,u*255,w*255,c)},ci={hsl:$r,hsla:$r,rgb:jr,rgba:jr},ce=function(r,A){return CA.parse(r,Vr.create(A).parseComponentValue())},cA={ALICEBLUE:4042850303,ANTIQUEWHITE:4209760255,AQUA:16777215,AQUAMARINE:2147472639,AZURE:4043309055,BEIGE:4126530815,BISQUE:4293182719,BLACK:255,BLANCHEDALMOND:4293643775,BLUE:65535,BLUEVIOLET:2318131967,BROWN:2771004159,BURLYWOOD:3736635391,CADETBLUE:1604231423,CHARTREUSE:2147418367,CHOCOLATE:3530104575,CORAL:4286533887,CORNFLOWERBLUE:1687547391,CORNSILK:4294499583,CRIMSON:3692313855,CYAN:16777215,DARKBLUE:35839,DARKCYAN:9145343,DARKGOLDENROD:3095837695,DARKGRAY:2846468607,DARKGREEN:6553855,DARKGREY:2846468607,DARKKHAKI:3182914559,DARKMAGENTA:2332068863,DARKOLIVEGREEN:1433087999,DARKORANGE:4287365375,DARKORCHID:2570243327,DARKRED:2332033279,DARKSALMON:3918953215,DARKSEAGREEN:2411499519,DARKSLATEBLUE:1211993087,DARKSLATEGRAY:793726975,DARKSLATEGREY:793726975,DARKTURQUOISE:13554175,DARKVIOLET:2483082239,DEEPPINK:4279538687,DEEPSKYBLUE:12582911,DIMGRAY:1768516095,DIMGREY:1768516095,DODGERBLUE:512819199,FIREBRICK:2988581631,FLORALWHITE:4294635775,FORESTGREEN:579543807,FUCHSIA:4278255615,GAINSBORO:3705462015,GHOSTWHITE:4177068031,GOLD:4292280575,GOLDENROD:3668254975,GRAY:2155905279,GREEN:8388863,GREENYELLOW:2919182335,GREY:2155905279,HONEYDEW:4043305215,HOTPINK:4285117695,INDIANRED:3445382399,INDIGO:1258324735,IVORY:4294963455,KHAKI:4041641215,LAVENDER:3873897215,LAVENDERBLUSH:4293981695,LAWNGREEN:2096890111,LEMONCHIFFON:4294626815,LIGHTBLUE:2916673279,LIGHTCORAL:4034953471,LIGHTCYAN:3774873599,LIGHTGOLDENRODYELLOW:4210742015,LIGHTGRAY:3553874943,LIGHTGREEN:2431553791,LIGHTGREY:3553874943,LIGHTPINK:4290167295,LIGHTSALMON:4288707327,LIGHTSEAGREEN:548580095,LIGHTSKYBLUE:2278488831,LIGHTSLATEGRAY:2005441023,LIGHTSLATEGREY:2005441023,LIGHTSTEELBLUE:2965692159,LIGHTYELLOW:4294959359,LIME:16711935,LIMEGREEN:852308735,LINEN:4210091775,MAGENTA:4278255615,MAROON:2147483903,MEDIUMAQUAMARINE:1724754687,MEDIUMBLUE:52735,MEDIUMORCHID:3126187007,MEDIUMPURPLE:2473647103,MEDIUMSEAGREEN:1018393087,MEDIUMSLATEBLUE:2070474495,MEDIUMSPRINGGREEN:16423679,MEDIUMTURQUOISE:1221709055,MEDIUMVIOLETRED:3340076543,MIDNIGHTBLUE:421097727,MINTCREAM:4127193855,MISTYROSE:4293190143,MOCCASIN:4293178879,NAVAJOWHITE:4292783615,NAVY:33023,OLDLACE:4260751103,OLIVE:2155872511,OLIVEDRAB:1804477439,ORANGE:4289003775,ORANGERED:4282712319,ORCHID:3664828159,PALEGOLDENROD:4008225535,PALEGREEN:2566625535,PALETURQUOISE:2951671551,PALEVIOLETRED:3681588223,PAPAYAWHIP:4293907967,PEACHPUFF:4292524543,PERU:3448061951,PINK:4290825215,PLUM:3718307327,POWDERBLUE:2967529215,PURPLE:2147516671,REBECCAPURPLE:1714657791,RED:4278190335,ROSYBROWN:3163525119,ROYALBLUE:1097458175,SADDLEBROWN:2336560127,SALMON:4202722047,SANDYBROWN:4104413439,SEAGREEN:780883967,SEASHELL:4294307583,SIENNA:2689740287,SILVER:3233857791,SKYBLUE:2278484991,SLATEBLUE:1784335871,SLATEGRAY:1887473919,SLATEGREY:1887473919,SNOW:4294638335,SPRINGGREEN:16744447,STEELBLUE:1182971135,TAN:3535047935,TEAL:8421631,THISTLE:3636451583,TOMATO:4284696575,TRANSPARENT:0,TURQUOISE:1088475391,VIOLET:4001558271,WHEAT:4125012991,WHITE:4294967295,WHITESMOKE:4126537215,YELLOW:4294902015,YELLOWGREEN:2597139199},li={name:"background-clip",initialValue:"border-box",prefix:!1,type:1,parse:function(r,A){return A.map(function(e){if(x(e))switch(e.value){case"padding-box":return 1;case"content-box":return 2}return 0})}},gi={name:"background-color",initialValue:"transparent",prefix:!1,type:3,format:"color"},Re=function(r,A){var e=CA.parse(r,A[0]),t=A[1];return t&&O(t)?{color:e,stop:t}:{color:e,stop:null}},zr=function(r,A){var e=r[0],t=r[r.length-1];e.stop===null&&(e.stop=R),t.stop===null&&(t.stop=fA);for(var s=[],n=0,a=0;a<r.length;a++){var B=r[a].stop;if(B!==null){var i=K(B,A);i>n?s.push(i):s.push(n),n=i}else s.push(null)}for(var o=null,a=0;a<s.length;a++){var c=s[a];if(c===null)o===null&&(o=a);else if(o!==null){for(var l=a-o,g=s[o-1],f=(c-g)/(l+1),u=1;u<=l;u++)s[o+u-1]=f*u;o=null}}return r.map(function(w,v){var U=w.color;return{color:U,stop:Math.max(Math.min(1,s[v]/A),0)}})},ui=function(r,A,e){var t=A/2,s=e/2,n=K(r[0],A)-t,a=s-K(r[1],e);return(Math.atan2(a,n)+Math.PI*2)%(Math.PI*2)},wi=function(r,A,e){var t=typeof r=="number"?r:ui(r,A,e),s=Math.abs(A*Math.sin(t))+Math.abs(e*Math.cos(t)),n=A/2,a=e/2,B=s/2,i=Math.sin(t-Math.PI/2)*B,o=Math.cos(t-Math.PI/2)*B;return[s,n-o,n+o,a-i,a+i]},rA=function(r,A){return Math.sqrt(r*r+A*A)},As=function(r,A,e,t,s){var n=[[0,0],[0,A],[r,0],[r,A]];return n.reduce(function(a,B){var i=B[0],o=B[1],c=rA(e-i,t-o);return(s?c<a.optimumDistance:c>a.optimumDistance)?{optimumCorner:B,optimumDistance:c}:a},{optimumDistance:s?1/0:-1/0,optimumCorner:null}).optimumCorner},Qi=function(r,A,e,t,s){var n=0,a=0;switch(r.size){case 0:r.shape===0?n=a=Math.min(Math.abs(A),Math.abs(A-t),Math.abs(e),Math.abs(e-s)):r.shape===1&&(n=Math.min(Math.abs(A),Math.abs(A-t)),a=Math.min(Math.abs(e),Math.abs(e-s)));break;case 2:if(r.shape===0)n=a=Math.min(rA(A,e),rA(A,e-s),rA(A-t,e),rA(A-t,e-s));else if(r.shape===1){var B=Math.min(Math.abs(e),Math.abs(e-s))/Math.min(Math.abs(A),Math.abs(A-t)),i=As(t,s,A,e,!0),o=i[0],c=i[1];n=rA(o-A,(c-e)/B),a=B*n}break;case 1:r.shape===0?n=a=Math.max(Math.abs(A),Math.abs(A-t),Math.abs(e),Math.abs(e-s)):r.shape===1&&(n=Math.max(Math.abs(A),Math.abs(A-t)),a=Math.max(Math.abs(e),Math.abs(e-s)));break;case 3:if(r.shape===0)n=a=Math.max(rA(A,e),rA(A,e-s),rA(A-t,e),rA(A-t,e-s));else if(r.shape===1){var B=Math.max(Math.abs(e),Math.abs(e-s))/Math.max(Math.abs(A),Math.abs(A-t)),l=As(t,s,A,e,!1),o=l[0],c=l[1];n=rA(o-A,(c-e)/B),a=B*n}break}return Array.isArray(r.size)&&(n=K(r.size[0],t),a=r.size.length===2?K(r.size[1],s):n),[n,a]},di=function(r,A){var e=$(180),t=[];return nA(A).forEach(function(s,n){if(n===0){var a=s[0];if(a.type===20&&a.value==="to"){e=Zr(s);return}else if(Yr(a)){e=ke.parse(r,a);return}}var B=Re(r,s);t.push(B)}),{angle:e,stops:t,type:1}},Ve=function(r,A){var e=$(180),t=[];return nA(A).forEach(function(s,n){if(n===0){var a=s[0];if(a.type===20&&["top","left","right","bottom"].indexOf(a.value)!==-1){e=Zr(s);return}else if(Yr(a)){e=(ke.parse(r,a)+$(270))%$(360);return}}var B=Re(r,s);t.push(B)}),{angle:e,stops:t,type:1}},fi=function(r,A){var e=$(180),t=[],s=1,n=0,a=3,B=[];return nA(A).forEach(function(i,o){var c=i[0];if(o===0){if(x(c)&&c.value==="linear"){s=1;return}else if(x(c)&&c.value==="radial"){s=2;return}}if(c.type===18){if(c.name==="from"){var l=CA.parse(r,c.values[0]);t.push({stop:R,color:l})}else if(c.name==="to"){var l=CA.parse(r,c.values[0]);t.push({stop:fA,color:l})}else if(c.name==="color-stop"){var g=c.values.filter(RA);if(g.length===2){var l=CA.parse(r,g[1]),f=g[0];kA(f)&&t.push({stop:{type:16,number:f.number*100,flags:f.flags},color:l})}}}}),s===1?{angle:(e+$(180))%$(360),stops:t,type:s}:{size:a,shape:n,stops:t,position:B,type:s}},es="closest-side",ts="farthest-side",rs="closest-corner",ss="farthest-corner",ns="circle",as="ellipse",is="cover",Bs="contain",Ci=function(r,A){var e=0,t=3,s=[],n=[];return nA(A).forEach(function(a,B){var i=!0;if(B===0){var o=!1;i=a.reduce(function(l,g){if(o)if(x(g))switch(g.value){case"center":return n.push(St),l;case"top":case"left":return n.push(R),l;case"right":case"bottom":return n.push(fA),l}else(O(g)||dA(g))&&n.push(g);else if(x(g))switch(g.value){case ns:return e=0,!1;case as:return e=1,!1;case"at":return o=!0,!1;case es:return t=0,!1;case is:case ts:return t=1,!1;case Bs:case rs:return t=2,!1;case ss:return t=3,!1}else if(dA(g)||O(g))return Array.isArray(t)||(t=[]),t.push(g),!1;return l},i)}if(i){var c=Re(r,a);s.push(c)}}),{size:t,shape:e,stops:s,position:n,type:2}},Ne=function(r,A){var e=0,t=3,s=[],n=[];return nA(A).forEach(function(a,B){var i=!0;if(B===0?i=a.reduce(function(c,l){if(x(l))switch(l.value){case"center":return n.push(St),!1;case"top":case"left":return n.push(R),!1;case"right":case"bottom":return n.push(fA),!1}else if(O(l)||dA(l))return n.push(l),!1;return c},i):B===1&&(i=a.reduce(function(c,l){if(x(l))switch(l.value){case ns:return e=0,!1;case as:return e=1,!1;case Bs:case es:return t=0,!1;case ts:return t=1,!1;case rs:return t=2,!1;case is:case ss:return t=3,!1}else if(dA(l)||O(l))return Array.isArray(t)||(t=[]),t.push(l),!1;return c},i)),i){var o=Re(r,a);s.push(o)}}),{size:t,shape:e,stops:s,position:n,type:2}},hi=function(r){return r.type===1},Ui=function(r){return r.type===2},Tt={name:"image",parse:function(r,A){if(A.type===22){var e={url:A.value,type:0};return r.cache.addImage(A.value),e}if(A.type===18){var t=os[A.name];if(typeof t>"u")throw new Error('Attempting to parse an unsupported image function "'+A.name+'"');return t(r,A.values)}throw new Error("Unsupported image type "+A.type)}};function Fi(r){return!(r.type===20&&r.value==="none")&&(r.type!==18||!!os[r.name])}var os={"linear-gradient":di,"-moz-linear-gradient":Ve,"-ms-linear-gradient":Ve,"-o-linear-gradient":Ve,"-webkit-linear-gradient":Ve,"radial-gradient":Ci,"-moz-radial-gradient":Ne,"-ms-radial-gradient":Ne,"-o-radial-gradient":Ne,"-webkit-radial-gradient":Ne,"-webkit-gradient":fi},pi={name:"background-image",initialValue:"none",type:1,prefix:!1,parse:function(r,A){if(A.length===0)return[];var e=A[0];return e.type===20&&e.value==="none"?[]:A.filter(function(t){return RA(t)&&Fi(t)}).map(function(t){return Tt.parse(r,t)})}},vi={name:"background-origin",initialValue:"border-box",prefix:!1,type:1,parse:function(r,A){return A.map(function(e){if(x(e))switch(e.value){case"padding-box":return 1;case"content-box":return 2}return 0})}},Ei={name:"background-position",initialValue:"0% 0%",type:1,prefix:!1,parse:function(r,A){return nA(A).map(function(e){return e.filter(O)}).map(Pr)}},Hi={name:"background-repeat",initialValue:"repeat",prefix:!1,type:1,parse:function(r,A){return nA(A).map(function(e){return e.filter(x).map(function(t){return t.value}).join(" ")}).map(yi)}},yi=function(r){switch(r){case"no-repeat":return 1;case"repeat-x":case"repeat no-repeat":return 2;case"repeat-y":case"no-repeat repeat":return 3;case"repeat":default:return 0}},VA;(function(r){r.AUTO="auto",r.CONTAIN="contain",r.COVER="cover"})(VA||(VA={}));var mi={name:"background-size",initialValue:"0",prefix:!1,type:1,parse:function(r,A){return nA(A).map(function(e){return e.filter(Ii)})}},Ii=function(r){return x(r)||O(r)},Pe=function(r){return{name:"border-"+r+"-color",initialValue:"transparent",prefix:!1,type:3,format:"color"}},bi=Pe("top"),xi=Pe("right"),Li=Pe("bottom"),Ki=Pe("left"),_e=function(r){return{name:"border-radius-"+r,initialValue:"0 0",prefix:!1,type:1,parse:function(A,e){return Pr(e.filter(O))}}},Si=_e("top-left"),Di=_e("top-right"),Ti=_e("bottom-right"),Oi=_e("bottom-left"),Xe=function(r){return{name:"border-"+r+"-style",initialValue:"solid",prefix:!1,type:2,parse:function(A,e){switch(e){case"none":return 0;case"dashed":return 2;case"dotted":return 3;case"double":return 4}return 1}}},Mi=Xe("top"),Gi=Xe("right"),ki=Xe("bottom"),Ri=Xe("left"),Je=function(r){return{name:"border-"+r+"-width",initialValue:"0",type:0,prefix:!1,parse:function(A,e){return Be(e)?e.number:0}}},Vi=Je("top"),Ni=Je("right"),Pi=Je("bottom"),_i=Je("left"),Xi={name:"color",initialValue:"transparent",prefix:!1,type:3,format:"color"},Ji={name:"direction",initialValue:"ltr",prefix:!1,type:2,parse:function(r,A){switch(A){case"rtl":return 1;case"ltr":default:return 0}}},Wi={name:"display",initialValue:"inline-block",prefix:!1,type:1,parse:function(r,A){return A.filter(x).reduce(function(e,t){return e|Yi(t.value)},0)}},Yi=function(r){switch(r){case"block":case"-webkit-box":return 2;case"inline":return 4;case"run-in":return 8;case"flow":return 16;case"flow-root":return 32;case"table":return 64;case"flex":case"-webkit-flex":return 128;case"grid":case"-ms-grid":return 256;case"ruby":return 512;case"subgrid":return 1024;case"list-item":return 2048;case"table-row-group":return 4096;case"table-header-group":return 8192;case"table-footer-group":return 16384;case"table-row":return 32768;case"table-cell":return 65536;case"table-column-group":return 131072;case"table-column":return 262144;case"table-caption":return 524288;case"ruby-base":return 1048576;case"ruby-text":return 2097152;case"ruby-base-container":return 4194304;case"ruby-text-container":return 8388608;case"contents":return 16777216;case"inline-block":return 33554432;case"inline-list-item":return 67108864;case"inline-table":return 134217728;case"inline-flex":return 268435456;case"inline-grid":return 536870912}return 0},Zi={name:"float",initialValue:"none",prefix:!1,type:2,parse:function(r,A){switch(A){case"left":return 1;case"right":return 2;case"inline-start":return 3;case"inline-end":return 4}return 0}},qi={name:"letter-spacing",initialValue:"0",prefix:!1,type:0,parse:function(r,A){return A.type===20&&A.value==="normal"?0:A.type===17||A.type===15?A.number:0}},We;(function(r){r.NORMAL="normal",r.STRICT="strict"})(We||(We={}));var ji={name:"line-break",initialValue:"normal",prefix:!1,type:2,parse:function(r,A){switch(A){case"strict":return We.STRICT;case"normal":default:return We.NORMAL}}},$i={name:"line-height",initialValue:"normal",prefix:!1,type:4},cs=function(r,A){return x(r)&&r.value==="normal"?1.2*A:r.type===17?A*r.number:O(r)?K(r,A):A},zi={name:"list-style-image",initialValue:"none",type:0,prefix:!1,parse:function(r,A){return A.type===20&&A.value==="none"?null:Tt.parse(r,A)}},AB={name:"list-style-position",initialValue:"outside",prefix:!1,type:2,parse:function(r,A){switch(A){case"inside":return 0;case"outside":default:return 1}}},Ot={name:"list-style-type",initialValue:"none",prefix:!1,type:2,parse:function(r,A){switch(A){case"disc":return 0;case"circle":return 1;case"square":return 2;case"decimal":return 3;case"cjk-decimal":return 4;case"decimal-leading-zero":return 5;case"lower-roman":return 6;case"upper-roman":return 7;case"lower-greek":return 8;case"lower-alpha":return 9;case"upper-alpha":return 10;case"arabic-indic":return 11;case"armenian":return 12;case"bengali":return 13;case"cambodian":return 14;case"cjk-earthly-branch":return 15;case"cjk-heavenly-stem":return 16;case"cjk-ideographic":return 17;case"devanagari":return 18;case"ethiopic-numeric":return 19;case"georgian":return 20;case"gujarati":return 21;case"gurmukhi":return 22;case"hebrew":return 22;case"hiragana":return 23;case"hiragana-iroha":return 24;case"japanese-formal":return 25;case"japanese-informal":return 26;case"kannada":return 27;case"katakana":return 28;case"katakana-iroha":return 29;case"khmer":return 30;case"korean-hangul-formal":return 31;case"korean-hanja-formal":return 32;case"korean-hanja-informal":return 33;case"lao":return 34;case"lower-armenian":return 35;case"malayalam":return 36;case"mongolian":return 37;case"myanmar":return 38;case"oriya":return 39;case"persian":return 40;case"simp-chinese-formal":return 41;case"simp-chinese-informal":return 42;case"tamil":return 43;case"telugu":return 44;case"thai":return 45;case"tibetan":return 46;case"trad-chinese-formal":return 47;case"trad-chinese-informal":return 48;case"upper-armenian":return 49;case"disclosure-open":return 50;case"disclosure-closed":return 51;case"none":default:return-1}}},Ye=function(r){return{name:"margin-"+r,initialValue:"0",prefix:!1,type:4}},eB=Ye("top"),tB=Ye("right"),rB=Ye("bottom"),sB=Ye("left"),nB={name:"overflow",initialValue:"visible",prefix:!1,type:1,parse:function(r,A){return A.filter(x).map(function(e){switch(e.value){case"hidden":return 1;case"scroll":return 2;case"clip":return 3;case"auto":return 4;case"visible":default:return 0}})}},aB={name:"overflow-wrap",initialValue:"normal",prefix:!1,type:2,parse:function(r,A){switch(A){case"break-word":return"break-word";case"normal":default:return"normal"}}},Ze=function(r){return{name:"padding-"+r,initialValue:"0",prefix:!1,type:3,format:"length-percentage"}},iB=Ze("top"),BB=Ze("right"),oB=Ze("bottom"),cB=Ze("left"),lB={name:"text-align",initialValue:"left",prefix:!1,type:2,parse:function(r,A){switch(A){case"right":return 2;case"center":case"justify":return 1;case"left":default:return 0}}},gB={name:"position",initialValue:"static",prefix:!1,type:2,parse:function(r,A){switch(A){case"relative":return 1;case"absolute":return 2;case"fixed":return 3;case"sticky":return 4}return 0}},uB={name:"text-shadow",initialValue:"none",type:1,prefix:!1,parse:function(r,A){return A.length===1&&Kt(A[0],"none")?[]:nA(A).map(function(e){for(var t={color:cA.TRANSPARENT,offsetX:R,offsetY:R,blur:R},s=0,n=0;n<e.length;n++){var a=e[n];dA(a)?(s===0?t.offsetX=a:s===1?t.offsetY=a:t.blur=a,s++):t.color=CA.parse(r,a)}return t})}},wB={name:"text-transform",initialValue:"none",prefix:!1,type:2,parse:function(r,A){switch(A){case"uppercase":return 2;case"lowercase":return 1;case"capitalize":return 3}return 0}},QB={name:"transform",initialValue:"none",prefix:!0,type:0,parse:function(r,A){if(A.type===20&&A.value==="none")return null;if(A.type===18){var e=CB[A.name];if(typeof e>"u")throw new Error('Attempting to parse an unsupported transform function "'+A.name+'"');return e(A.values)}return null}},dB=function(r){var A=r.filter(function(e){return e.type===17}).map(function(e){return e.number});return A.length===6?A:null},fB=function(r){var A=r.filter(function(i){return i.type===17}).map(function(i){return i.number}),e=A[0],t=A[1];A[2],A[3];var s=A[4],n=A[5];A[6],A[7],A[8],A[9],A[10],A[11];var a=A[12],B=A[13];return A[14],A[15],A.length===16?[e,t,s,n,a,B]:null},CB={matrix:dB,matrix3d:fB},ls={type:16,number:50,flags:re},hB=[ls,ls],UB={name:"transform-origin",initialValue:"50% 50%",prefix:!0,type:1,parse:function(r,A){var e=A.filter(O);return e.length!==2?hB:[e[0],e[1]]}},FB={name:"visible",initialValue:"none",prefix:!1,type:2,parse:function(r,A){switch(A){case"hidden":return 1;case"collapse":return 2;case"visible":default:return 0}}},le;(function(r){r.NORMAL="normal",r.BREAK_ALL="break-all",r.KEEP_ALL="keep-all"})(le||(le={}));for(var pB={name:"word-break",initialValue:"normal",prefix:!1,type:2,parse:function(r,A){switch(A){case"break-all":return le.BREAK_ALL;case"keep-all":return le.KEEP_ALL;case"normal":default:return le.NORMAL}}},vB={name:"z-index",initialValue:"auto",prefix:!1,type:0,parse:function(r,A){if(A.type===20)return{auto:!0,order:0};if(kA(A))return{auto:!1,order:A.number};throw new Error("Invalid z-index number parsed")}},gs={name:"time",parse:function(r,A){if(A.type===15)switch(A.unit.toLowerCase()){case"s":return 1e3*A.number;case"ms":return A.number}throw new Error("Unsupported time type")}},EB={name:"opacity",initialValue:"1",type:0,prefix:!1,parse:function(r,A){return kA(A)?A.number:1}},HB={name:"text-decoration-color",initialValue:"transparent",prefix:!1,type:3,format:"color"},yB={name:"text-decoration-line",initialValue:"none",prefix:!1,type:1,parse:function(r,A){return A.filter(x).map(function(e){switch(e.value){case"underline":return 1;case"overline":return 2;case"line-through":return 3;case"none":return 4}return 0}).filter(function(e){return e!==0})}},mB={name:"font-family",initialValue:"",prefix:!1,type:1,parse:function(r,A){var e=[],t=[];return A.forEach(function(s){switch(s.type){case 20:case 0:e.push(s.value);break;case 17:e.push(s.number.toString());break;case 4:t.push(e.join(" ")),e.length=0;break}}),e.length&&t.push(e.join(" ")),t.map(function(s){return s.indexOf(" ")===-1?s:"'"+s+"'"})}},IB={name:"font-size",initialValue:"0",prefix:!1,type:3,format:"length"},bB={name:"font-weight",initialValue:"normal",type:0,prefix:!1,parse:function(r,A){if(kA(A))return A.number;if(x(A))switch(A.value){case"bold":return 700;case"normal":default:return 400}return 400}},xB={name:"font-variant",initialValue:"none",type:1,prefix:!1,parse:function(r,A){return A.filter(x).map(function(e){return e.value})}},LB={name:"font-style",initialValue:"normal",prefix:!1,type:2,parse:function(r,A){switch(A){case"oblique":return"oblique";case"italic":return"italic";case"normal":default:return"normal"}}},G=function(r,A){return(r&A)!==0},KB={name:"content",initialValue:"none",type:1,prefix:!1,parse:function(r,A){if(A.length===0)return[];var e=A[0];return e.type===20&&e.value==="none"?[]:A}},SB={name:"counter-increment",initialValue:"none",prefix:!0,type:1,parse:function(r,A){if(A.length===0)return null;var e=A[0];if(e.type===20&&e.value==="none")return null;for(var t=[],s=A.filter(Nr),n=0;n<s.length;n++){var a=s[n],B=s[n+1];if(a.type===20){var i=B&&kA(B)?B.number:1;t.push({counter:a.value,increment:i})}}return t}},DB={name:"counter-reset",initialValue:"none",prefix:!0,type:1,parse:function(r,A){if(A.length===0)return[];for(var e=[],t=A.filter(Nr),s=0;s<t.length;s++){var n=t[s],a=t[s+1];if(x(n)&&n.value!=="none"){var B=a&&kA(a)?a.number:0;e.push({counter:n.value,reset:B})}}return e}},TB={name:"duration",initialValue:"0s",prefix:!1,type:1,parse:function(r,A){return A.filter(Be).map(function(e){return gs.parse(r,e)})}},OB={name:"quotes",initialValue:"none",prefix:!0,type:1,parse:function(r,A){if(A.length===0)return null;var e=A[0];if(e.type===20&&e.value==="none")return null;var t=[],s=A.filter(Bi);if(s.length%2!==0)return null;for(var n=0;n<s.length;n+=2){var a=s[n].value,B=s[n+1].value;t.push({open:a,close:B})}return t}},us=function(r,A,e){if(!r)return"";var t=r[Math.min(A,r.length-1)];return t?e?t.open:t.close:""},MB={name:"box-shadow",initialValue:"none",type:1,prefix:!1,parse:function(r,A){return A.length===1&&Kt(A[0],"none")?[]:nA(A).map(function(e){for(var t={color:255,offsetX:R,offsetY:R,blur:R,spread:R,inset:!1},s=0,n=0;n<e.length;n++){var a=e[n];Kt(a,"inset")?t.inset=!0:dA(a)?(s===0?t.offsetX=a:s===1?t.offsetY=a:s===2?t.blur=a:t.spread=a,s++):t.color=CA.parse(r,a)}return t})}},GB={name:"paint-order",initialValue:"normal",prefix:!1,type:1,parse:function(r,A){var e=[0,1,2],t=[];return A.filter(x).forEach(function(s){switch(s.value){case"stroke":t.push(1);break;case"fill":t.push(0);break;case"markers":t.push(2);break}}),e.forEach(function(s){t.indexOf(s)===-1&&t.push(s)}),t}},kB={name:"-webkit-text-stroke-color",initialValue:"currentcolor",prefix:!1,type:3,format:"color"},RB={name:"-webkit-text-stroke-width",initialValue:"0",type:0,prefix:!1,parse:function(r,A){return Be(A)?A.number:0}},VB=(function(){function r(A,e){var t,s;this.animationDuration=C(A,TB,e.animationDuration),this.backgroundClip=C(A,li,e.backgroundClip),this.backgroundColor=C(A,gi,e.backgroundColor),this.backgroundImage=C(A,pi,e.backgroundImage),this.backgroundOrigin=C(A,vi,e.backgroundOrigin),this.backgroundPosition=C(A,Ei,e.backgroundPosition),this.backgroundRepeat=C(A,Hi,e.backgroundRepeat),this.backgroundSize=C(A,mi,e.backgroundSize),this.borderTopColor=C(A,bi,e.borderTopColor),this.borderRightColor=C(A,xi,e.borderRightColor),this.borderBottomColor=C(A,Li,e.borderBottomColor),this.borderLeftColor=C(A,Ki,e.borderLeftColor),this.borderTopLeftRadius=C(A,Si,e.borderTopLeftRadius),this.borderTopRightRadius=C(A,Di,e.borderTopRightRadius),this.borderBottomRightRadius=C(A,Ti,e.borderBottomRightRadius),this.borderBottomLeftRadius=C(A,Oi,e.borderBottomLeftRadius),this.borderTopStyle=C(A,Mi,e.borderTopStyle),this.borderRightStyle=C(A,Gi,e.borderRightStyle),this.borderBottomStyle=C(A,ki,e.borderBottomStyle),this.borderLeftStyle=C(A,Ri,e.borderLeftStyle),this.borderTopWidth=C(A,Vi,e.borderTopWidth),this.borderRightWidth=C(A,Ni,e.borderRightWidth),this.borderBottomWidth=C(A,Pi,e.borderBottomWidth),this.borderLeftWidth=C(A,_i,e.borderLeftWidth),this.boxShadow=C(A,MB,e.boxShadow),this.color=C(A,Xi,e.color),this.direction=C(A,Ji,e.direction),this.display=C(A,Wi,e.display),this.float=C(A,Zi,e.cssFloat),this.fontFamily=C(A,mB,e.fontFamily),this.fontSize=C(A,IB,e.fontSize),this.fontStyle=C(A,LB,e.fontStyle),this.fontVariant=C(A,xB,e.fontVariant),this.fontWeight=C(A,bB,e.fontWeight),this.letterSpacing=C(A,qi,e.letterSpacing),this.lineBreak=C(A,ji,e.lineBreak),this.lineHeight=C(A,$i,e.lineHeight),this.listStyleImage=C(A,zi,e.listStyleImage),this.listStylePosition=C(A,AB,e.listStylePosition),this.listStyleType=C(A,Ot,e.listStyleType),this.marginTop=C(A,eB,e.marginTop),this.marginRight=C(A,tB,e.marginRight),this.marginBottom=C(A,rB,e.marginBottom),this.marginLeft=C(A,sB,e.marginLeft),this.opacity=C(A,EB,e.opacity);var n=C(A,nB,e.overflow);this.overflowX=n[0],this.overflowY=n[n.length>1?1:0],this.overflowWrap=C(A,aB,e.overflowWrap),this.paddingTop=C(A,iB,e.paddingTop),this.paddingRight=C(A,BB,e.paddingRight),this.paddingBottom=C(A,oB,e.paddingBottom),this.paddingLeft=C(A,cB,e.paddingLeft),this.paintOrder=C(A,GB,e.paintOrder),this.position=C(A,gB,e.position),this.textAlign=C(A,lB,e.textAlign),this.textDecorationColor=C(A,HB,(t=e.textDecorationColor)!==null&&t!==void 0?t:e.color),this.textDecorationLine=C(A,yB,(s=e.textDecorationLine)!==null&&s!==void 0?s:e.textDecoration),this.textShadow=C(A,uB,e.textShadow),this.textTransform=C(A,wB,e.textTransform),this.transform=C(A,QB,e.transform),this.transformOrigin=C(A,UB,e.transformOrigin),this.visibility=C(A,FB,e.visibility),this.webkitTextStrokeColor=C(A,kB,e.webkitTextStrokeColor),this.webkitTextStrokeWidth=C(A,RB,e.webkitTextStrokeWidth),this.wordBreak=C(A,pB,e.wordBreak),this.zIndex=C(A,vB,e.zIndex)}return r.prototype.isVisible=function(){return this.display>0&&this.opacity>0&&this.visibility===0},r.prototype.isTransparent=function(){return hA(this.backgroundColor)},r.prototype.isTransformed=function(){return this.transform!==null},r.prototype.isPositioned=function(){return this.position!==0},r.prototype.isPositionedWithZIndex=function(){return this.isPositioned()&&!this.zIndex.auto},r.prototype.isFloating=function(){return this.float!==0},r.prototype.isInlineLevel=function(){return G(this.display,4)||G(this.display,33554432)||G(this.display,268435456)||G(this.display,536870912)||G(this.display,67108864)||G(this.display,134217728)},r})(),NB=(function(){function r(A,e){this.content=C(A,KB,e.content),this.quotes=C(A,OB,e.quotes)}return r})(),ws=(function(){function r(A,e){this.counterIncrement=C(A,SB,e.counterIncrement),this.counterReset=C(A,DB,e.counterReset)}return r})(),C=function(r,A,e){var t=new Rr,s=e!==null&&typeof e<"u"?e.toString():A.initialValue;t.write(s);var n=new Vr(t.read());switch(A.type){case 2:var a=n.parseComponentValue();return A.parse(r,x(a)?a.value:A.initialValue);case 0:return A.parse(r,n.parseComponentValue());case 1:return A.parse(r,n.parseComponentValues());case 4:return n.parseComponentValue();case 3:switch(A.format){case"angle":return ke.parse(r,n.parseComponentValue());case"color":return CA.parse(r,n.parseComponentValue());case"image":return Tt.parse(r,n.parseComponentValue());case"length":var B=n.parseComponentValue();return dA(B)?B:R;case"length-percentage":var i=n.parseComponentValue();return O(i)?i:R;case"time":return gs.parse(r,n.parseComponentValue())}break}},PB="data-html2canvas-debug",_B=function(r){var A=r.getAttribute(PB);switch(A){case"all":return 1;case"clone":return 2;case"parse":return 3;case"render":return 4;default:return 0}},Mt=function(r,A){var e=_B(r);return e===1||A===e},aA=(function(){function r(A,e){if(this.context=A,this.textNodes=[],this.elements=[],this.flags=0,Mt(e,3))debugger;this.styles=new VB(A,window.getComputedStyle(e,null)),jt(e)&&(this.styles.animationDuration.some(function(t){return t>0})&&(e.style.animationDuration="0s"),this.styles.transform!==null&&(e.style.transform="none")),this.bounds=he(this.context,e),Mt(e,4)&&(this.flags|=16)}return r})(),XB="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",Qs="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",ge=typeof Uint8Array>"u"?[]:new Uint8Array(256),qe=0;qe<Qs.length;qe++)ge[Qs.charCodeAt(qe)]=qe;for(var JB=function(r){var A=r.length*.75,e=r.length,t,s=0,n,a,B,i;r[r.length-1]==="="&&(A--,r[r.length-2]==="="&&A--);var o=typeof ArrayBuffer<"u"&&typeof Uint8Array<"u"&&typeof Uint8Array.prototype.slice<"u"?new ArrayBuffer(A):new Array(A),c=Array.isArray(o)?o:new Uint8Array(o);for(t=0;t<e;t+=4)n=ge[r.charCodeAt(t)],a=ge[r.charCodeAt(t+1)],B=ge[r.charCodeAt(t+2)],i=ge[r.charCodeAt(t+3)],c[s++]=n<<2|a>>4,c[s++]=(a&15)<<4|B>>2,c[s++]=(B&3)<<6|i&63;return o},WB=function(r){for(var A=r.length,e=[],t=0;t<A;t+=2)e.push(r[t+1]<<8|r[t]);return e},YB=function(r){for(var A=r.length,e=[],t=0;t<A;t+=4)e.push(r[t+3]<<24|r[t+2]<<16|r[t+1]<<8|r[t]);return e},bA=5,Gt=11,kt=2,ZB=Gt-bA,ds=65536>>bA,qB=1<<bA,Rt=qB-1,jB=1024>>bA,$B=ds+jB,zB=$B,Ao=32,eo=zB+Ao,to=65536>>Gt,ro=1<<ZB,so=ro-1,fs=function(r,A,e){return r.slice?r.slice(A,e):new Uint16Array(Array.prototype.slice.call(r,A,e))},no=function(r,A,e){return r.slice?r.slice(A,e):new Uint32Array(Array.prototype.slice.call(r,A,e))},ao=function(r,A){var e=JB(r),t=Array.isArray(e)?YB(e):new Uint32Array(e),s=Array.isArray(e)?WB(e):new Uint16Array(e),n=24,a=fs(s,n/2,t[4]/2),B=t[5]===2?fs(s,(n+t[4])/2):no(t,Math.ceil((n+t[4])/4));return new io(t[0],t[1],t[2],t[3],a,B)},io=(function(){function r(A,e,t,s,n,a){this.initialValue=A,this.errorValue=e,this.highStart=t,this.highValueIndex=s,this.index=n,this.data=a}return r.prototype.get=function(A){var e;if(A>=0){if(A<55296||A>56319&&A<=65535)return e=this.index[A>>bA],e=(e<<kt)+(A&Rt),this.data[e];if(A<=65535)return e=this.index[ds+(A-55296>>bA)],e=(e<<kt)+(A&Rt),this.data[e];if(A<this.highStart)return e=eo-to+(A>>Gt),e=this.index[e],e+=A>>bA&so,e=this.index[e],e=(e<<kt)+(A&Rt),this.data[e];if(A<=1114111)return this.data[this.highValueIndex]}return this.errorValue},r})(),Cs="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",Bo=typeof Uint8Array>"u"?[]:new Uint8Array(256),je=0;je<Cs.length;je++)Bo[Cs.charCodeAt(je)]=je;var oo=1,Vt=2,Nt=3,hs=4,Us=5,co=7,Fs=8,Pt=9,_t=10,ps=11,vs=12,Es=13,Hs=14,Xt=15,lo=function(r){for(var A=[],e=0,t=r.length;e<t;){var s=r.charCodeAt(e++);if(s>=55296&&s<=56319&&e<t){var n=r.charCodeAt(e++);(n&64512)===56320?A.push(((s&1023)<<10)+(n&1023)+65536):(A.push(s),e--)}else A.push(s)}return A},go=function(){for(var r=[],A=0;A<arguments.length;A++)r[A]=arguments[A];if(String.fromCodePoint)return String.fromCodePoint.apply(String,r);var e=r.length;if(!e)return"";for(var t=[],s=-1,n="";++s<e;){var a=r[s];a<=65535?t.push(a):(a-=65536,t.push((a>>10)+55296,a%1024+56320)),(s+1===e||t.length>16384)&&(n+=String.fromCharCode.apply(String,t),t.length=0)}return n},uo=ao(XB),z="×",Jt="÷",wo=function(r){return uo.get(r)},Qo=function(r,A,e){var t=e-2,s=A[t],n=A[e-1],a=A[e];if(n===Vt&&a===Nt)return z;if(n===Vt||n===Nt||n===hs||a===Vt||a===Nt||a===hs)return Jt;if(n===Fs&&[Fs,Pt,ps,vs].indexOf(a)!==-1||(n===ps||n===Pt)&&(a===Pt||a===_t)||(n===vs||n===_t)&&a===_t||a===Es||a===Us||a===co||n===oo)return z;if(n===Es&&a===Hs){for(;s===Us;)s=A[--t];if(s===Hs)return z}if(n===Xt&&a===Xt){for(var B=0;s===Xt;)B++,s=A[--t];if(B%2===0)return z}return Jt},fo=function(r){var A=lo(r),e=A.length,t=0,s=0,n=A.map(wo);return{next:function(){if(t>=e)return{done:!0,value:null};for(var a=z;t<e&&(a=Qo(A,n,++t))===z;);if(a!==z||t===e){var B=go.apply(null,A.slice(s,t));return s=t,{value:B,done:!1}}return{done:!0,value:null}}}},Co=function(r){for(var A=fo(r),e=[],t;!(t=A.next()).done;)t.value&&e.push(t.value.slice());return e},ho=function(r){var A=123;if(r.createRange){var e=r.createRange();if(e.getBoundingClientRect){var t=r.createElement("boundtest");t.style.height=A+"px",t.style.display="block",r.body.appendChild(t),e.selectNode(t);var s=e.getBoundingClientRect(),n=Math.round(s.height);if(r.body.removeChild(t),n===A)return!0}}return!1},Uo=function(r){var A=r.createElement("boundtest");A.style.width="50px",A.style.display="block",A.style.fontSize="12px",A.style.letterSpacing="0px",A.style.wordSpacing="0px",r.body.appendChild(A);var e=r.createRange();A.innerHTML=typeof"".repeat=="function"?"&#128104;".repeat(10):"";var t=A.firstChild,s=Ue(t.data).map(function(i){return D(i)}),n=0,a={},B=s.every(function(i,o){e.setStart(t,n),e.setEnd(t,n+i.length);var c=e.getBoundingClientRect();n+=i.length;var l=c.x>a.x||c.y>a.y;return a=c,o===0?!0:l});return r.body.removeChild(A),B},Fo=function(){return typeof new Image().crossOrigin<"u"},po=function(){return typeof new XMLHttpRequest().responseType=="string"},vo=function(r){var A=new Image,e=r.createElement("canvas"),t=e.getContext("2d");if(!t)return!1;A.src="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg'></svg>";try{t.drawImage(A,0,0),e.toDataURL()}catch{return!1}return!0},ys=function(r){return r[0]===0&&r[1]===255&&r[2]===0&&r[3]===255},Eo=function(r){var A=r.createElement("canvas"),e=100;A.width=e,A.height=e;var t=A.getContext("2d");if(!t)return Promise.reject(!1);t.fillStyle="rgb(0, 255, 0)",t.fillRect(0,0,e,e);var s=new Image,n=A.toDataURL();s.src=n;var a=Wt(e,e,0,0,s);return t.fillStyle="red",t.fillRect(0,0,e,e),ms(a).then(function(B){t.drawImage(B,0,0);var i=t.getImageData(0,0,e,e).data;t.fillStyle="red",t.fillRect(0,0,e,e);var o=r.createElement("div");return o.style.backgroundImage="url("+n+")",o.style.height=e+"px",ys(i)?ms(Wt(e,e,0,0,o)):Promise.reject(!1)}).then(function(B){return t.drawImage(B,0,0),ys(t.getImageData(0,0,e,e).data)}).catch(function(){return!1})},Wt=function(r,A,e,t,s){var n="http://www.w3.org/2000/svg",a=document.createElementNS(n,"svg"),B=document.createElementNS(n,"foreignObject");return a.setAttributeNS(null,"width",r.toString()),a.setAttributeNS(null,"height",A.toString()),B.setAttributeNS(null,"width","100%"),B.setAttributeNS(null,"height","100%"),B.setAttributeNS(null,"x",e.toString()),B.setAttributeNS(null,"y",t.toString()),B.setAttributeNS(null,"externalResourcesRequired","true"),a.appendChild(B),B.appendChild(s),a},ms=function(r){return new Promise(function(A,e){var t=new Image;t.onload=function(){return A(t)},t.onerror=e,t.src="data:image/svg+xml;charset=utf-8,"+encodeURIComponent(new XMLSerializer().serializeToString(r))})},V={get SUPPORT_RANGE_BOUNDS(){var r=ho(document);return Object.defineProperty(V,"SUPPORT_RANGE_BOUNDS",{value:r}),r},get SUPPORT_WORD_BREAKING(){var r=V.SUPPORT_RANGE_BOUNDS&&Uo(document);return Object.defineProperty(V,"SUPPORT_WORD_BREAKING",{value:r}),r},get SUPPORT_SVG_DRAWING(){var r=vo(document);return Object.defineProperty(V,"SUPPORT_SVG_DRAWING",{value:r}),r},get SUPPORT_FOREIGNOBJECT_DRAWING(){var r=typeof Array.from=="function"&&typeof window.fetch=="function"?Eo(document):Promise.resolve(!1);return Object.defineProperty(V,"SUPPORT_FOREIGNOBJECT_DRAWING",{value:r}),r},get SUPPORT_CORS_IMAGES(){var r=Fo();return Object.defineProperty(V,"SUPPORT_CORS_IMAGES",{value:r}),r},get SUPPORT_RESPONSE_TYPE(){var r=po();return Object.defineProperty(V,"SUPPORT_RESPONSE_TYPE",{value:r}),r},get SUPPORT_CORS_XHR(){var r="withCredentials"in new XMLHttpRequest;return Object.defineProperty(V,"SUPPORT_CORS_XHR",{value:r}),r},get SUPPORT_NATIVE_TEXT_SEGMENTATION(){var r=!!(typeof Intl<"u"&&Intl.Segmenter);return Object.defineProperty(V,"SUPPORT_NATIVE_TEXT_SEGMENTATION",{value:r}),r}},ue=(function(){function r(A,e){this.text=A,this.bounds=e}return r})(),Ho=function(r,A,e,t){var s=Io(A,e),n=[],a=0;return s.forEach(function(B){if(e.textDecorationLine.length||B.trim().length>0)if(V.SUPPORT_RANGE_BOUNDS){var i=Is(t,a,B.length).getClientRects();if(i.length>1){var o=Yt(B),c=0;o.forEach(function(g){n.push(new ue(g,BA.fromDOMRectList(r,Is(t,c+a,g.length).getClientRects()))),c+=g.length})}else n.push(new ue(B,BA.fromDOMRectList(r,i)))}else{var l=t.splitText(B.length);n.push(new ue(B,yo(r,t))),t=l}else V.SUPPORT_RANGE_BOUNDS||(t=t.splitText(B.length));a+=B.length}),n},yo=function(r,A){var e=A.ownerDocument;if(e){var t=e.createElement("html2canvaswrapper");t.appendChild(A.cloneNode(!0));var s=A.parentNode;if(s){s.replaceChild(t,A);var n=he(r,t);return t.firstChild&&s.replaceChild(t.firstChild,t),n}}return BA.EMPTY},Is=function(r,A,e){var t=r.ownerDocument;if(!t)throw new Error("Node has no owner document");var s=t.createRange();return s.setStart(r,A),s.setEnd(r,A+e),s},Yt=function(r){if(V.SUPPORT_NATIVE_TEXT_SEGMENTATION){var A=new Intl.Segmenter(void 0,{granularity:"grapheme"});return Array.from(A.segment(r)).map(function(e){return e.segment})}return Co(r)},mo=function(r,A){if(V.SUPPORT_NATIVE_TEXT_SEGMENTATION){var e=new Intl.Segmenter(void 0,{granularity:"word"});return Array.from(e.segment(r)).map(function(t){return t.segment})}return xo(r,A)},Io=function(r,A){return A.letterSpacing!==0?Yt(r):mo(r,A)},bo=[32,160,4961,65792,65793,4153,4241],xo=function(r,A){for(var e=ta(r,{lineBreak:A.lineBreak,wordBreak:A.overflowWrap==="break-word"?"break-word":A.wordBreak}),t=[],s,n=function(){if(s.value){var a=s.value.slice(),B=Ue(a),i="";B.forEach(function(o){bo.indexOf(o)===-1?i+=D(o):(i.length&&t.push(i),t.push(D(o)),i="")}),i.length&&t.push(i)}};!(s=e.next()).done;)n();return t},Lo=(function(){function r(A,e,t){this.text=Ko(e.data,t.textTransform),this.textBounds=Ho(A,this.text,t,e)}return r})(),Ko=function(r,A){switch(A){case 1:return r.toLowerCase();case 3:return r.replace(So,Do);case 2:return r.toUpperCase();default:return r}},So=/(^|\s|:|-|\(|\))([a-z])/g,Do=function(r,A,e){return r.length>0?A+e.toUpperCase():r},bs=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s.src=t.currentSrc||t.src,s.intrinsicWidth=t.naturalWidth,s.intrinsicHeight=t.naturalHeight,s.context.cache.addImage(s.src),s}return A})(aA),xs=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s.canvas=t,s.intrinsicWidth=t.width,s.intrinsicHeight=t.height,s}return A})(aA),Ls=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this,n=new XMLSerializer,a=he(e,t);return t.setAttribute("width",a.width+"px"),t.setAttribute("height",a.height+"px"),s.svg="data:image/svg+xml,"+encodeURIComponent(n.serializeToString(t)),s.intrinsicWidth=t.width.baseVal.value,s.intrinsicHeight=t.height.baseVal.value,s.context.cache.addImage(s.svg),s}return A})(aA),Ks=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s.value=t.value,s}return A})(aA),Zt=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s.start=t.start,s.reversed=typeof t.reversed=="boolean"&&t.reversed===!0,s}return A})(aA),To=[{type:15,flags:0,unit:"px",number:3}],Oo=[{type:16,flags:0,number:50}],Mo=function(r){return r.width>r.height?new BA(r.left+(r.width-r.height)/2,r.top,r.height,r.height):r.width<r.height?new BA(r.left,r.top+(r.height-r.width)/2,r.width,r.width):r},Go=function(r){var A=r.type===ko?new Array(r.value.length+1).join("•"):r.value;return A.length===0?r.placeholder||"":A},$e="checkbox",ze="radio",ko="password",Ss=707406591,qt=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;switch(s.type=t.type.toLowerCase(),s.checked=t.checked,s.value=Go(t),(s.type===$e||s.type===ze)&&(s.styles.backgroundColor=3739148031,s.styles.borderTopColor=s.styles.borderRightColor=s.styles.borderBottomColor=s.styles.borderLeftColor=2779096575,s.styles.borderTopWidth=s.styles.borderRightWidth=s.styles.borderBottomWidth=s.styles.borderLeftWidth=1,s.styles.borderTopStyle=s.styles.borderRightStyle=s.styles.borderBottomStyle=s.styles.borderLeftStyle=1,s.styles.backgroundClip=[0],s.styles.backgroundOrigin=[0],s.bounds=Mo(s.bounds)),s.type){case $e:s.styles.borderTopRightRadius=s.styles.borderTopLeftRadius=s.styles.borderBottomRightRadius=s.styles.borderBottomLeftRadius=To;break;case ze:s.styles.borderTopRightRadius=s.styles.borderTopLeftRadius=s.styles.borderBottomRightRadius=s.styles.borderBottomLeftRadius=Oo;break}return s}return A})(aA),Ds=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this,n=t.options[t.selectedIndex||0];return s.value=n&&n.text||"",s}return A})(aA),Ts=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s.value=t.value,s}return A})(aA),Os=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;s.src=t.src,s.width=parseInt(t.width,10)||0,s.height=parseInt(t.height,10)||0,s.backgroundColor=s.styles.backgroundColor;try{if(t.contentWindow&&t.contentWindow.document&&t.contentWindow.document.documentElement){s.tree=Gs(e,t.contentWindow.document.documentElement);var n=t.contentWindow.document.documentElement?ce(e,getComputedStyle(t.contentWindow.document.documentElement).backgroundColor):cA.TRANSPARENT,a=t.contentWindow.document.body?ce(e,getComputedStyle(t.contentWindow.document.body).backgroundColor):cA.TRANSPARENT;s.backgroundColor=hA(n)?hA(a)?s.styles.backgroundColor:a:n}}catch{}return s}return A})(aA),Ro=["OL","UL","MENU"],At=function(r,A,e,t){for(var s=A.firstChild,n=void 0;s;s=n)if(n=s.nextSibling,ks(s)&&s.data.trim().length>0)e.textNodes.push(new Lo(r,s,e.styles));else if(NA(s))if(Xs(s)&&s.assignedNodes)s.assignedNodes().forEach(function(B){return At(r,B,e,t)});else{var a=Ms(r,s);a.styles.isVisible()&&(Vo(s,a,t)?a.flags|=4:No(a.styles)&&(a.flags|=2),Ro.indexOf(s.tagName)!==-1&&(a.flags|=8),e.elements.push(a),s.slot,s.shadowRoot?At(r,s.shadowRoot,a,t):!tt(s)&&!Rs(s)&&!rt(s)&&At(r,s,a,t))}},Ms=function(r,A){return zt(A)?new bs(r,A):Vs(A)?new xs(r,A):Rs(A)?new Ls(r,A):Po(A)?new Ks(r,A):_o(A)?new Zt(r,A):Xo(A)?new qt(r,A):rt(A)?new Ds(r,A):tt(A)?new Ts(r,A):Ps(A)?new Os(r,A):new aA(r,A)},Gs=function(r,A){var e=Ms(r,A);return e.flags|=4,At(r,A,e,e),e},Vo=function(r,A,e){return A.styles.isPositionedWithZIndex()||A.styles.opacity<1||A.styles.isTransformed()||$t(r)&&e.styles.isTransparent()},No=function(r){return r.isPositioned()||r.isFloating()},ks=function(r){return r.nodeType===Node.TEXT_NODE},NA=function(r){return r.nodeType===Node.ELEMENT_NODE},jt=function(r){return NA(r)&&typeof r.style<"u"&&!et(r)},et=function(r){return typeof r.className=="object"},Po=function(r){return r.tagName==="LI"},_o=function(r){return r.tagName==="OL"},Xo=function(r){return r.tagName==="INPUT"},Jo=function(r){return r.tagName==="HTML"},Rs=function(r){return r.tagName==="svg"},$t=function(r){return r.tagName==="BODY"},Vs=function(r){return r.tagName==="CANVAS"},Ns=function(r){return r.tagName==="VIDEO"},zt=function(r){return r.tagName==="IMG"},Ps=function(r){return r.tagName==="IFRAME"},_s=function(r){return r.tagName==="STYLE"},Wo=function(r){return r.tagName==="SCRIPT"},tt=function(r){return r.tagName==="TEXTAREA"},rt=function(r){return r.tagName==="SELECT"},Xs=function(r){return r.tagName==="SLOT"},Js=function(r){return r.tagName.indexOf("-")>0},Yo=(function(){function r(){this.counters={}}return r.prototype.getCounterValue=function(A){var e=this.counters[A];return e&&e.length?e[e.length-1]:1},r.prototype.getCounterValues=function(A){var e=this.counters[A];return e||[]},r.prototype.pop=function(A){var e=this;A.forEach(function(t){return e.counters[t].pop()})},r.prototype.parse=function(A){var e=this,t=A.counterIncrement,s=A.counterReset,n=!0;t!==null&&t.forEach(function(B){var i=e.counters[B.counter];i&&B.increment!==0&&(n=!1,i.length||i.push(1),i[Math.max(0,i.length-1)]+=B.increment)});var a=[];return n&&s.forEach(function(B){var i=e.counters[B.counter];a.push(B.counter),i||(i=e.counters[B.counter]=[]),i.push(B.reset)}),a},r})(),Ws={integers:[1e3,900,500,400,100,90,50,40,10,9,5,4,1],values:["M","CM","D","CD","C","XC","L","XL","X","IX","V","IV","I"]},Ys={integers:[9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:["Ք","Փ","Ւ","Ց","Ր","Տ","Վ","Ս","Ռ","Ջ","Պ","Չ","Ո","Շ","Ն","Յ","Մ","Ճ","Ղ","Ձ","Հ","Կ","Ծ","Խ","Լ","Ի","Ժ","Թ","Ը","Է","Զ","Ե","Դ","Գ","Բ","Ա"]},Zo={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,400,300,200,100,90,80,70,60,50,40,30,20,19,18,17,16,15,10,9,8,7,6,5,4,3,2,1],values:["י׳","ט׳","ח׳","ז׳","ו׳","ה׳","ד׳","ג׳","ב׳","א׳","ת","ש","ר","ק","צ","פ","ע","ס","נ","מ","ל","כ","יט","יח","יז","טז","טו","י","ט","ח","ז","ו","ה","ד","ג","ב","א"]},qo={integers:[1e4,9e3,8e3,7e3,6e3,5e3,4e3,3e3,2e3,1e3,900,800,700,600,500,400,300,200,100,90,80,70,60,50,40,30,20,10,9,8,7,6,5,4,3,2,1],values:["ჵ","ჰ","ჯ","ჴ","ხ","ჭ","წ","ძ","ც","ჩ","შ","ყ","ღ","ქ","ფ","ჳ","ტ","ს","რ","ჟ","პ","ო","ჲ","ნ","მ","ლ","კ","ი","თ","ჱ","ზ","ვ","ე","დ","გ","ბ","ა"]},PA=function(r,A,e,t,s,n){return r<A||r>e?Qe(r,s,n.length>0):t.integers.reduce(function(a,B,i){for(;r>=B;)r-=B,a+=t.values[i];return a},"")+n},Zs=function(r,A,e,t){var s="";do e||r--,s=t(r)+s,r/=A;while(r*A>=A);return s},T=function(r,A,e,t,s){var n=e-A+1;return(r<0?"-":"")+(Zs(Math.abs(r),n,t,function(a){return D(Math.floor(a%n)+A)})+s)},xA=function(r,A,e){e===void 0&&(e=". ");var t=A.length;return Zs(Math.abs(r),t,!1,function(s){return A[Math.floor(s%t)]})+e},_A=1,FA=2,pA=4,we=8,lA=function(r,A,e,t,s,n){if(r<-9999||r>9999)return Qe(r,4,s.length>0);var a=Math.abs(r),B=s;if(a===0)return A[0]+B;for(var i=0;a>0&&i<=4;i++){var o=a%10;o===0&&G(n,_A)&&B!==""?B=A[o]+B:o>1||o===1&&i===0||o===1&&i===1&&G(n,FA)||o===1&&i===1&&G(n,pA)&&r>100||o===1&&i>1&&G(n,we)?B=A[o]+(i>0?e[i-1]:"")+B:o===1&&i>0&&(B=e[i-1]+B),a=Math.floor(a/10)}return(r<0?t:"")+B},qs="十百千萬",js="拾佰仟萬",$s="マイナス",Ar="마이너스",Qe=function(r,A,e){var t=e?". ":"",s=e?"、":"",n=e?", ":"",a=e?" ":"";switch(A){case 0:return"•"+a;case 1:return"◦"+a;case 2:return"◾"+a;case 5:var B=T(r,48,57,!0,t);return B.length<4?"0"+B:B;case 4:return xA(r,"〇一二三四五六七八九",s);case 6:return PA(r,1,3999,Ws,3,t).toLowerCase();case 7:return PA(r,1,3999,Ws,3,t);case 8:return T(r,945,969,!1,t);case 9:return T(r,97,122,!1,t);case 10:return T(r,65,90,!1,t);case 11:return T(r,1632,1641,!0,t);case 12:case 49:return PA(r,1,9999,Ys,3,t);case 35:return PA(r,1,9999,Ys,3,t).toLowerCase();case 13:return T(r,2534,2543,!0,t);case 14:case 30:return T(r,6112,6121,!0,t);case 15:return xA(r,"子丑寅卯辰巳午未申酉戌亥",s);case 16:return xA(r,"甲乙丙丁戊己庚辛壬癸",s);case 17:case 48:return lA(r,"零一二三四五六七八九",qs,"負",s,FA|pA|we);case 47:return lA(r,"零壹貳參肆伍陸柒捌玖",js,"負",s,_A|FA|pA|we);case 42:return lA(r,"零一二三四五六七八九",qs,"负",s,FA|pA|we);case 41:return lA(r,"零壹贰叁肆伍陆柒捌玖",js,"负",s,_A|FA|pA|we);case 26:return lA(r,"〇一二三四五六七八九","十百千万",$s,s,0);case 25:return lA(r,"零壱弐参四伍六七八九","拾百千万",$s,s,_A|FA|pA);case 31:return lA(r,"영일이삼사오육칠팔구","십백천만",Ar,n,_A|FA|pA);case 33:return lA(r,"零一二三四五六七八九","十百千萬",Ar,n,0);case 32:return lA(r,"零壹貳參四五六七八九","拾百千",Ar,n,_A|FA|pA);case 18:return T(r,2406,2415,!0,t);case 20:return PA(r,1,19999,qo,3,t);case 21:return T(r,2790,2799,!0,t);case 22:return T(r,2662,2671,!0,t);case 22:return PA(r,1,10999,Zo,3,t);case 23:return xA(r,"あいうえおかきくけこさしすせそたちつてとなにぬねのはひふへほまみむめもやゆよらりるれろわゐゑをん");case 24:return xA(r,"いろはにほへとちりぬるをわかよたれそつねならむうゐのおくやまけふこえてあさきゆめみしゑひもせす");case 27:return T(r,3302,3311,!0,t);case 28:return xA(r,"アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヰヱヲン",s);case 29:return xA(r,"イロハニホヘトチリヌルヲワカヨタレソツネナラムウヰノオクヤマケフコエテアサキユメミシヱヒモセス",s);case 34:return T(r,3792,3801,!0,t);case 37:return T(r,6160,6169,!0,t);case 38:return T(r,4160,4169,!0,t);case 39:return T(r,2918,2927,!0,t);case 40:return T(r,1776,1785,!0,t);case 43:return T(r,3046,3055,!0,t);case 44:return T(r,3174,3183,!0,t);case 45:return T(r,3664,3673,!0,t);case 46:return T(r,3872,3881,!0,t);case 3:default:return T(r,48,57,!0,t)}},zs="data-html2canvas-ignore",An=(function(){function r(A,e,t){if(this.context=A,this.options=t,this.scrolledElements=[],this.referenceElement=e,this.counters=new Yo,this.quoteDepth=0,!e.ownerDocument)throw new Error("Cloned element does not have an owner document");this.documentElement=this.cloneNode(e.ownerDocument.documentElement,!1)}return r.prototype.toIFrame=function(A,e){var t=this,s=jo(A,e);if(!s.contentWindow)return Promise.reject("Unable to find iframe window");var n=A.defaultView.pageXOffset,a=A.defaultView.pageYOffset,B=s.contentWindow,i=B.document,o=Ac(s).then(function(){return X(t,void 0,void 0,function(){var c,l;return P(this,function(g){switch(g.label){case 0:return this.scrolledElements.forEach(sc),B&&(B.scrollTo(e.left,e.top),/(iPad|iPhone|iPod)/g.test(navigator.userAgent)&&(B.scrollY!==e.top||B.scrollX!==e.left)&&(this.context.logger.warn("Unable to restore scroll position for cloned document"),this.context.windowBounds=this.context.windowBounds.add(B.scrollX-e.left,B.scrollY-e.top,0,0))),c=this.options.onclone,l=this.clonedReferenceElement,typeof l>"u"?[2,Promise.reject("Error finding the "+this.referenceElement.nodeName+" in the cloned document")]:i.fonts&&i.fonts.ready?[4,i.fonts.ready]:[3,2];case 1:g.sent(),g.label=2;case 2:return/(AppleWebKit)/g.test(navigator.userAgent)?[4,zo(i)]:[3,4];case 3:g.sent(),g.label=4;case 4:return typeof c=="function"?[2,Promise.resolve().then(function(){return c(i,l)}).then(function(){return s})]:[2,s]}})})});return i.open(),i.write(tc(document.doctype)+"<html></html>"),rc(this.referenceElement.ownerDocument,n,a),i.replaceChild(i.adoptNode(this.documentElement),i.documentElement),i.close(),o},r.prototype.createElementClone=function(A){if(Mt(A,2))debugger;if(Vs(A))return this.createCanvasClone(A);if(Ns(A))return this.createVideoClone(A);if(_s(A))return this.createStyleClone(A);var e=A.cloneNode(!1);return zt(e)&&(zt(A)&&A.currentSrc&&A.currentSrc!==A.src&&(e.src=A.currentSrc,e.srcset=""),e.loading==="lazy"&&(e.loading="eager")),Js(e)?this.createCustomElementClone(e):e},r.prototype.createCustomElementClone=function(A){var e=document.createElement("html2canvascustomelement");return er(A.style,e),e},r.prototype.createStyleClone=function(A){try{var e=A.sheet;if(e&&e.cssRules){var t=[].slice.call(e.cssRules,0).reduce(function(n,a){return a&&typeof a.cssText=="string"?n+a.cssText:n},""),s=A.cloneNode(!1);return s.textContent=t,s}}catch(n){if(this.context.logger.error("Unable to access cssRules property",n),n.name!=="SecurityError")throw n}return A.cloneNode(!1)},r.prototype.createCanvasClone=function(A){var e;if(this.options.inlineImages&&A.ownerDocument){var t=A.ownerDocument.createElement("img");try{return t.src=A.toDataURL(),t}catch{this.context.logger.info("Unable to inline canvas contents, canvas is tainted",A)}}var s=A.cloneNode(!1);try{s.width=A.width,s.height=A.height;var n=A.getContext("2d"),a=s.getContext("2d");if(a)if(!this.options.allowTaint&&n)a.putImageData(n.getImageData(0,0,A.width,A.height),0,0);else{var B=(e=A.getContext("webgl2"))!==null&&e!==void 0?e:A.getContext("webgl");if(B){var i=B.getContextAttributes();i?.preserveDrawingBuffer===!1&&this.context.logger.warn("Unable to clone WebGL context as it has preserveDrawingBuffer=false",A)}a.drawImage(A,0,0)}return s}catch{this.context.logger.info("Unable to clone canvas as it is tainted",A)}return s},r.prototype.createVideoClone=function(A){var e=A.ownerDocument.createElement("canvas");e.width=A.offsetWidth,e.height=A.offsetHeight;var t=e.getContext("2d");try{return t&&(t.drawImage(A,0,0,e.width,e.height),this.options.allowTaint||t.getImageData(0,0,e.width,e.height)),e}catch{this.context.logger.info("Unable to clone video as it is tainted",A)}var s=A.ownerDocument.createElement("canvas");return s.width=A.offsetWidth,s.height=A.offsetHeight,s},r.prototype.appendChildNode=function(A,e,t){(!NA(e)||!Wo(e)&&!e.hasAttribute(zs)&&(typeof this.options.ignoreElements!="function"||!this.options.ignoreElements(e)))&&(!this.options.copyStyles||!NA(e)||!_s(e))&&A.appendChild(this.cloneNode(e,t))},r.prototype.cloneChildNodes=function(A,e,t){for(var s=this,n=A.shadowRoot?A.shadowRoot.firstChild:A.firstChild;n;n=n.nextSibling)if(NA(n)&&Xs(n)&&typeof n.assignedNodes=="function"){var a=n.assignedNodes();a.length&&a.forEach(function(B){return s.appendChildNode(e,B,t)})}else this.appendChildNode(e,n,t)},r.prototype.cloneNode=function(A,e){if(ks(A))return document.createTextNode(A.data);if(!A.ownerDocument)return A.cloneNode(!1);var t=A.ownerDocument.defaultView;if(t&&NA(A)&&(jt(A)||et(A))){var s=this.createElementClone(A);s.style.transitionProperty="none";var n=t.getComputedStyle(A),a=t.getComputedStyle(A,":before"),B=t.getComputedStyle(A,":after");this.referenceElement===A&&jt(s)&&(this.clonedReferenceElement=s),$t(s)&&ic(s);var i=this.counters.parse(new ws(this.context,n)),o=this.resolvePseudoContent(A,s,a,de.BEFORE);Js(A)&&(e=!0),Ns(A)||this.cloneChildNodes(A,s,e),o&&s.insertBefore(o,s.firstChild);var c=this.resolvePseudoContent(A,s,B,de.AFTER);return c&&s.appendChild(c),this.counters.pop(i),(n&&(this.options.copyStyles||et(A))&&!Ps(A)||e)&&er(n,s),(A.scrollTop!==0||A.scrollLeft!==0)&&this.scrolledElements.push([s,A.scrollLeft,A.scrollTop]),(tt(A)||rt(A))&&(tt(s)||rt(s))&&(s.value=A.value),s}return A.cloneNode(!1)},r.prototype.resolvePseudoContent=function(A,e,t,s){var n=this;if(t){var a=t.content,B=e.ownerDocument;if(!(!B||!a||a==="none"||a==="-moz-alt-content"||t.display==="none")){this.counters.parse(new ws(this.context,t));var i=new NB(this.context,t),o=B.createElement("html2canvaspseudoelement");er(t,o),i.content.forEach(function(l){if(l.type===0)o.appendChild(B.createTextNode(l.value));else if(l.type===22){var g=B.createElement("img");g.src=l.value,g.style.opacity="1",o.appendChild(g)}else if(l.type===18){if(l.name==="attr"){var f=l.values.filter(x);f.length&&o.appendChild(B.createTextNode(A.getAttribute(f[0].value)||""))}else if(l.name==="counter"){var u=l.values.filter(RA),w=u[0],v=u[1];if(w&&x(w)){var U=n.counters.getCounterValue(w.value),h=v&&x(v)?Ot.parse(n.context,v.value):3;o.appendChild(B.createTextNode(Qe(U,h,!1)))}}else if(l.name==="counters"){var I=l.values.filter(RA),w=I[0],E=I[1],v=I[2];if(w&&x(w)){var F=n.counters.getCounterValues(w.value),d=v&&x(v)?Ot.parse(n.context,v.value):3,y=E&&E.type===0?E.value:"",m=F.map(function(W){return Qe(W,d,!1)}).join(y);o.appendChild(B.createTextNode(m))}}}else if(l.type===20)switch(l.value){case"open-quote":o.appendChild(B.createTextNode(us(i.quotes,n.quoteDepth++,!0)));break;case"close-quote":o.appendChild(B.createTextNode(us(i.quotes,--n.quoteDepth,!1)));break;default:o.appendChild(B.createTextNode(l.value))}}),o.className=tr+" "+rr;var c=s===de.BEFORE?" "+tr:" "+rr;return et(e)?e.className.baseValue+=c:e.className+=c,o}}},r.destroy=function(A){return A.parentNode?(A.parentNode.removeChild(A),!0):!1},r})(),de;(function(r){r[r.BEFORE=0]="BEFORE",r[r.AFTER=1]="AFTER"})(de||(de={}));var jo=function(r,A){var e=r.createElement("iframe");return e.className="html2canvas-container",e.style.visibility="hidden",e.style.position="fixed",e.style.left="-10000px",e.style.top="0px",e.style.border="0",e.width=A.width.toString(),e.height=A.height.toString(),e.scrolling="no",e.setAttribute(zs,"true"),r.body.appendChild(e),e},$o=function(r){return new Promise(function(A){if(r.complete){A();return}if(!r.src){A();return}r.onload=A,r.onerror=A})},zo=function(r){return Promise.all([].slice.call(r.images,0).map($o))},Ac=function(r){return new Promise(function(A,e){var t=r.contentWindow;if(!t)return e("No window assigned for iframe");var s=t.document;t.onload=r.onload=function(){t.onload=r.onload=null;var n=setInterval(function(){s.body.childNodes.length>0&&s.readyState==="complete"&&(clearInterval(n),A(r))},50)}})},ec=["all","d","content"],er=function(r,A){for(var e=r.length-1;e>=0;e--){var t=r.item(e);ec.indexOf(t)===-1&&A.style.setProperty(t,r.getPropertyValue(t))}return A},tc=function(r){var A="";return r&&(A+="<!DOCTYPE ",r.name&&(A+=r.name),r.internalSubset&&(A+=r.internalSubset),r.publicId&&(A+='"'+r.publicId+'"'),r.systemId&&(A+='"'+r.systemId+'"'),A+=">"),A},rc=function(r,A,e){r&&r.defaultView&&(A!==r.defaultView.pageXOffset||e!==r.defaultView.pageYOffset)&&r.defaultView.scrollTo(A,e)},sc=function(r){var A=r[0],e=r[1],t=r[2];A.scrollLeft=e,A.scrollTop=t},nc=":before",ac=":after",tr="___html2canvas___pseudoelement_before",rr="___html2canvas___pseudoelement_after",en=`{
    content: "" !important;
    display: none !important;
}`,ic=function(r){Bc(r,"."+tr+nc+en+`
         .`+rr+ac+en)},Bc=function(r,A){var e=r.ownerDocument;if(e){var t=e.createElement("style");t.textContent=A,r.appendChild(t)}},tn=(function(){function r(){}return r.getOrigin=function(A){var e=r._link;return e?(e.href=A,e.href=e.href,e.protocol+e.hostname+e.port):"about:blank"},r.isSameOrigin=function(A){return r.getOrigin(A)===r._origin},r.setContext=function(A){r._link=A.document.createElement("a"),r._origin=r.getOrigin(A.location.href)},r._origin="about:blank",r})(),oc=(function(){function r(A,e){this.context=A,this._options=e,this._cache={}}return r.prototype.addImage=function(A){var e=Promise.resolve();return this.has(A)||(nr(A)||uc(A))&&(this._cache[A]=this.loadImage(A)).catch(function(){}),e},r.prototype.match=function(A){return this._cache[A]},r.prototype.loadImage=function(A){return X(this,void 0,void 0,function(){var e,t,s,n,a=this;return P(this,function(B){switch(B.label){case 0:return e=tn.isSameOrigin(A),t=!sr(A)&&this._options.useCORS===!0&&V.SUPPORT_CORS_IMAGES&&!e,s=!sr(A)&&!e&&!nr(A)&&typeof this._options.proxy=="string"&&V.SUPPORT_CORS_XHR&&!t,!e&&this._options.allowTaint===!1&&!sr(A)&&!nr(A)&&!s&&!t?[2]:(n=A,s?[4,this.proxy(n)]:[3,2]);case 1:n=B.sent(),B.label=2;case 2:return this.context.logger.debug("Added image "+A.substring(0,256)),[4,new Promise(function(i,o){var c=new Image;c.onload=function(){return i(c)},c.onerror=o,(wc(n)||t)&&(c.crossOrigin="anonymous"),c.src=n,c.complete===!0&&setTimeout(function(){return i(c)},500),a._options.imageTimeout>0&&setTimeout(function(){return o("Timed out ("+a._options.imageTimeout+"ms) loading image")},a._options.imageTimeout)})];case 3:return[2,B.sent()]}})})},r.prototype.has=function(A){return typeof this._cache[A]<"u"},r.prototype.keys=function(){return Promise.resolve(Object.keys(this._cache))},r.prototype.proxy=function(A){var e=this,t=this._options.proxy;if(!t)throw new Error("No proxy defined");var s=A.substring(0,256);return new Promise(function(n,a){var B=V.SUPPORT_RESPONSE_TYPE?"blob":"text",i=new XMLHttpRequest;i.onload=function(){if(i.status===200)if(B==="text")n(i.response);else{var l=new FileReader;l.addEventListener("load",function(){return n(l.result)},!1),l.addEventListener("error",function(g){return a(g)},!1),l.readAsDataURL(i.response)}else a("Failed to proxy resource "+s+" with status code "+i.status)},i.onerror=a;var o=t.indexOf("?")>-1?"&":"?";if(i.open("GET",""+t+o+"url="+encodeURIComponent(A)+"&responseType="+B),B!=="text"&&i instanceof XMLHttpRequest&&(i.responseType=B),e._options.imageTimeout){var c=e._options.imageTimeout;i.timeout=c,i.ontimeout=function(){return a("Timed out ("+c+"ms) proxying "+s)}}i.send()})},r})(),cc=/^data:image\/svg\+xml/i,lc=/^data:image\/.*;base64,/i,gc=/^data:image\/.*/i,uc=function(r){return V.SUPPORT_SVG_DRAWING||!Qc(r)},sr=function(r){return gc.test(r)},wc=function(r){return lc.test(r)},nr=function(r){return r.substr(0,4)==="blob"},Qc=function(r){return r.substr(-3).toLowerCase()==="svg"||cc.test(r)},Q=(function(){function r(A,e){this.type=0,this.x=A,this.y=e}return r.prototype.add=function(A,e){return new r(this.x+A,this.y+e)},r})(),XA=function(r,A,e){return new Q(r.x+(A.x-r.x)*e,r.y+(A.y-r.y)*e)},st=(function(){function r(A,e,t,s){this.type=1,this.start=A,this.startControl=e,this.endControl=t,this.end=s}return r.prototype.subdivide=function(A,e){var t=XA(this.start,this.startControl,A),s=XA(this.startControl,this.endControl,A),n=XA(this.endControl,this.end,A),a=XA(t,s,A),B=XA(s,n,A),i=XA(a,B,A);return e?new r(this.start,t,a,i):new r(i,B,n,this.end)},r.prototype.add=function(A,e){return new r(this.start.add(A,e),this.startControl.add(A,e),this.endControl.add(A,e),this.end.add(A,e))},r.prototype.reverse=function(){return new r(this.end,this.endControl,this.startControl,this.start)},r})(),AA=function(r){return r.type===1},dc=(function(){function r(A){var e=A.styles,t=A.bounds,s=oe(e.borderTopLeftRadius,t.width,t.height),n=s[0],a=s[1],B=oe(e.borderTopRightRadius,t.width,t.height),i=B[0],o=B[1],c=oe(e.borderBottomRightRadius,t.width,t.height),l=c[0],g=c[1],f=oe(e.borderBottomLeftRadius,t.width,t.height),u=f[0],w=f[1],v=[];v.push((n+i)/t.width),v.push((u+l)/t.width),v.push((a+w)/t.height),v.push((o+g)/t.height);var U=Math.max.apply(Math,v);U>1&&(n/=U,a/=U,i/=U,o/=U,l/=U,g/=U,u/=U,w/=U);var h=t.width-i,I=t.height-g,E=t.width-l,F=t.height-w,d=e.borderTopWidth,y=e.borderRightWidth,m=e.borderBottomWidth,p=e.borderLeftWidth,M=K(e.paddingTop,A.bounds.width),W=K(e.paddingRight,A.bounds.width),j=K(e.paddingBottom,A.bounds.width),L=K(e.paddingLeft,A.bounds.width);this.topLeftBorderDoubleOuterBox=n>0||a>0?S(t.left+p/3,t.top+d/3,n-p/3,a-d/3,b.TOP_LEFT):new Q(t.left+p/3,t.top+d/3),this.topRightBorderDoubleOuterBox=n>0||a>0?S(t.left+h,t.top+d/3,i-y/3,o-d/3,b.TOP_RIGHT):new Q(t.left+t.width-y/3,t.top+d/3),this.bottomRightBorderDoubleOuterBox=l>0||g>0?S(t.left+E,t.top+I,l-y/3,g-m/3,b.BOTTOM_RIGHT):new Q(t.left+t.width-y/3,t.top+t.height-m/3),this.bottomLeftBorderDoubleOuterBox=u>0||w>0?S(t.left+p/3,t.top+F,u-p/3,w-m/3,b.BOTTOM_LEFT):new Q(t.left+p/3,t.top+t.height-m/3),this.topLeftBorderDoubleInnerBox=n>0||a>0?S(t.left+p*2/3,t.top+d*2/3,n-p*2/3,a-d*2/3,b.TOP_LEFT):new Q(t.left+p*2/3,t.top+d*2/3),this.topRightBorderDoubleInnerBox=n>0||a>0?S(t.left+h,t.top+d*2/3,i-y*2/3,o-d*2/3,b.TOP_RIGHT):new Q(t.left+t.width-y*2/3,t.top+d*2/3),this.bottomRightBorderDoubleInnerBox=l>0||g>0?S(t.left+E,t.top+I,l-y*2/3,g-m*2/3,b.BOTTOM_RIGHT):new Q(t.left+t.width-y*2/3,t.top+t.height-m*2/3),this.bottomLeftBorderDoubleInnerBox=u>0||w>0?S(t.left+p*2/3,t.top+F,u-p*2/3,w-m*2/3,b.BOTTOM_LEFT):new Q(t.left+p*2/3,t.top+t.height-m*2/3),this.topLeftBorderStroke=n>0||a>0?S(t.left+p/2,t.top+d/2,n-p/2,a-d/2,b.TOP_LEFT):new Q(t.left+p/2,t.top+d/2),this.topRightBorderStroke=n>0||a>0?S(t.left+h,t.top+d/2,i-y/2,o-d/2,b.TOP_RIGHT):new Q(t.left+t.width-y/2,t.top+d/2),this.bottomRightBorderStroke=l>0||g>0?S(t.left+E,t.top+I,l-y/2,g-m/2,b.BOTTOM_RIGHT):new Q(t.left+t.width-y/2,t.top+t.height-m/2),this.bottomLeftBorderStroke=u>0||w>0?S(t.left+p/2,t.top+F,u-p/2,w-m/2,b.BOTTOM_LEFT):new Q(t.left+p/2,t.top+t.height-m/2),this.topLeftBorderBox=n>0||a>0?S(t.left,t.top,n,a,b.TOP_LEFT):new Q(t.left,t.top),this.topRightBorderBox=i>0||o>0?S(t.left+h,t.top,i,o,b.TOP_RIGHT):new Q(t.left+t.width,t.top),this.bottomRightBorderBox=l>0||g>0?S(t.left+E,t.top+I,l,g,b.BOTTOM_RIGHT):new Q(t.left+t.width,t.top+t.height),this.bottomLeftBorderBox=u>0||w>0?S(t.left,t.top+F,u,w,b.BOTTOM_LEFT):new Q(t.left,t.top+t.height),this.topLeftPaddingBox=n>0||a>0?S(t.left+p,t.top+d,Math.max(0,n-p),Math.max(0,a-d),b.TOP_LEFT):new Q(t.left+p,t.top+d),this.topRightPaddingBox=i>0||o>0?S(t.left+Math.min(h,t.width-y),t.top+d,h>t.width+y?0:Math.max(0,i-y),Math.max(0,o-d),b.TOP_RIGHT):new Q(t.left+t.width-y,t.top+d),this.bottomRightPaddingBox=l>0||g>0?S(t.left+Math.min(E,t.width-p),t.top+Math.min(I,t.height-m),Math.max(0,l-y),Math.max(0,g-m),b.BOTTOM_RIGHT):new Q(t.left+t.width-y,t.top+t.height-m),this.bottomLeftPaddingBox=u>0||w>0?S(t.left+p,t.top+Math.min(F,t.height-m),Math.max(0,u-p),Math.max(0,w-m),b.BOTTOM_LEFT):new Q(t.left+p,t.top+t.height-m),this.topLeftContentBox=n>0||a>0?S(t.left+p+L,t.top+d+M,Math.max(0,n-(p+L)),Math.max(0,a-(d+M)),b.TOP_LEFT):new Q(t.left+p+L,t.top+d+M),this.topRightContentBox=i>0||o>0?S(t.left+Math.min(h,t.width+p+L),t.top+d+M,h>t.width+p+L?0:i-p+L,o-(d+M),b.TOP_RIGHT):new Q(t.left+t.width-(y+W),t.top+d+M),this.bottomRightContentBox=l>0||g>0?S(t.left+Math.min(E,t.width-(p+L)),t.top+Math.min(I,t.height+d+M),Math.max(0,l-(y+W)),g-(m+j),b.BOTTOM_RIGHT):new Q(t.left+t.width-(y+W),t.top+t.height-(m+j)),this.bottomLeftContentBox=u>0||w>0?S(t.left+p+L,t.top+F,Math.max(0,u-(p+L)),w-(m+j),b.BOTTOM_LEFT):new Q(t.left+p+L,t.top+t.height-(m+j))}return r})(),b;(function(r){r[r.TOP_LEFT=0]="TOP_LEFT",r[r.TOP_RIGHT=1]="TOP_RIGHT",r[r.BOTTOM_RIGHT=2]="BOTTOM_RIGHT",r[r.BOTTOM_LEFT=3]="BOTTOM_LEFT"})(b||(b={}));var S=function(r,A,e,t,s){var n=4*((Math.sqrt(2)-1)/3),a=e*n,B=t*n,i=r+e,o=A+t;switch(s){case b.TOP_LEFT:return new st(new Q(r,o),new Q(r,o-B),new Q(i-a,A),new Q(i,A));case b.TOP_RIGHT:return new st(new Q(r,A),new Q(r+a,A),new Q(i,o-B),new Q(i,o));case b.BOTTOM_RIGHT:return new st(new Q(i,A),new Q(i,A+B),new Q(r+a,o),new Q(r,o));case b.BOTTOM_LEFT:default:return new st(new Q(i,o),new Q(i-a,o),new Q(r,A+B),new Q(r,A))}},nt=function(r){return[r.topLeftBorderBox,r.topRightBorderBox,r.bottomRightBorderBox,r.bottomLeftBorderBox]},fc=function(r){return[r.topLeftContentBox,r.topRightContentBox,r.bottomRightContentBox,r.bottomLeftContentBox]},at=function(r){return[r.topLeftPaddingBox,r.topRightPaddingBox,r.bottomRightPaddingBox,r.bottomLeftPaddingBox]},Cc=(function(){function r(A,e,t){this.offsetX=A,this.offsetY=e,this.matrix=t,this.type=0,this.target=6}return r})(),it=(function(){function r(A,e){this.path=A,this.target=e,this.type=1}return r})(),hc=(function(){function r(A){this.opacity=A,this.type=2,this.target=6}return r})(),Uc=function(r){return r.type===0},rn=function(r){return r.type===1},Fc=function(r){return r.type===2},sn=function(r,A){return r.length===A.length?r.some(function(e,t){return e===A[t]}):!1},pc=function(r,A,e,t,s){return r.map(function(n,a){switch(a){case 0:return n.add(A,e);case 1:return n.add(A+t,e);case 2:return n.add(A+t,e+s);case 3:return n.add(A,e+s)}return n})},nn=(function(){function r(A){this.element=A,this.inlineLevel=[],this.nonInlineLevel=[],this.negativeZIndex=[],this.zeroOrAutoZIndexOrTransformedOrOpacity=[],this.positiveZIndex=[],this.nonPositionedFloats=[],this.nonPositionedInlineLevel=[]}return r})(),an=(function(){function r(A,e){if(this.container=A,this.parent=e,this.effects=[],this.curves=new dc(this.container),this.container.styles.opacity<1&&this.effects.push(new hc(this.container.styles.opacity)),this.container.styles.transform!==null){var t=this.container.bounds.left+this.container.styles.transformOrigin[0].number,s=this.container.bounds.top+this.container.styles.transformOrigin[1].number,n=this.container.styles.transform;this.effects.push(new Cc(t,s,n))}if(this.container.styles.overflowX!==0){var a=nt(this.curves),B=at(this.curves);sn(a,B)?this.effects.push(new it(a,6)):(this.effects.push(new it(a,2)),this.effects.push(new it(B,4)))}}return r.prototype.getEffects=function(A){for(var e=[2,3].indexOf(this.container.styles.position)===-1,t=this.parent,s=this.effects.slice(0);t;){var n=t.effects.filter(function(i){return!rn(i)});if(e||t.container.styles.position!==0||!t.parent){if(s.unshift.apply(s,n),e=[2,3].indexOf(t.container.styles.position)===-1,t.container.styles.overflowX!==0){var a=nt(t.curves),B=at(t.curves);sn(a,B)||s.unshift(new it(B,6))}}else s.unshift.apply(s,n);t=t.parent}return s.filter(function(i){return G(i.target,A)})},r})(),ar=function(r,A,e,t){r.container.elements.forEach(function(s){var n=G(s.flags,4),a=G(s.flags,2),B=new an(s,r);G(s.styles.display,2048)&&t.push(B);var i=G(s.flags,8)?[]:t;if(n||a){var o=n||s.styles.isPositioned()?e:A,c=new nn(B);if(s.styles.isPositioned()||s.styles.opacity<1||s.styles.isTransformed()){var l=s.styles.zIndex.order;if(l<0){var g=0;o.negativeZIndex.some(function(u,w){return l>u.element.container.styles.zIndex.order?(g=w,!1):g>0}),o.negativeZIndex.splice(g,0,c)}else if(l>0){var f=0;o.positiveZIndex.some(function(u,w){return l>=u.element.container.styles.zIndex.order?(f=w+1,!1):f>0}),o.positiveZIndex.splice(f,0,c)}else o.zeroOrAutoZIndexOrTransformedOrOpacity.push(c)}else s.styles.isFloating()?o.nonPositionedFloats.push(c):o.nonPositionedInlineLevel.push(c);ar(B,c,n?c:e,i)}else s.styles.isInlineLevel()?A.inlineLevel.push(B):A.nonInlineLevel.push(B),ar(B,A,e,i);G(s.flags,8)&&Bn(s,i)})},Bn=function(r,A){for(var e=r instanceof Zt?r.start:1,t=r instanceof Zt?r.reversed:!1,s=0;s<A.length;s++){var n=A[s];n.container instanceof Ks&&typeof n.container.value=="number"&&n.container.value!==0&&(e=n.container.value),n.listValue=Qe(e,n.container.styles.listStyleType,!0),e+=t?-1:1}},vc=function(r){var A=new an(r,null),e=new nn(A),t=[];return ar(A,e,e,t),Bn(A.container,t),e},on=function(r,A){switch(A){case 0:return eA(r.topLeftBorderBox,r.topLeftPaddingBox,r.topRightBorderBox,r.topRightPaddingBox);case 1:return eA(r.topRightBorderBox,r.topRightPaddingBox,r.bottomRightBorderBox,r.bottomRightPaddingBox);case 2:return eA(r.bottomRightBorderBox,r.bottomRightPaddingBox,r.bottomLeftBorderBox,r.bottomLeftPaddingBox);case 3:default:return eA(r.bottomLeftBorderBox,r.bottomLeftPaddingBox,r.topLeftBorderBox,r.topLeftPaddingBox)}},Ec=function(r,A){switch(A){case 0:return eA(r.topLeftBorderBox,r.topLeftBorderDoubleOuterBox,r.topRightBorderBox,r.topRightBorderDoubleOuterBox);case 1:return eA(r.topRightBorderBox,r.topRightBorderDoubleOuterBox,r.bottomRightBorderBox,r.bottomRightBorderDoubleOuterBox);case 2:return eA(r.bottomRightBorderBox,r.bottomRightBorderDoubleOuterBox,r.bottomLeftBorderBox,r.bottomLeftBorderDoubleOuterBox);case 3:default:return eA(r.bottomLeftBorderBox,r.bottomLeftBorderDoubleOuterBox,r.topLeftBorderBox,r.topLeftBorderDoubleOuterBox)}},Hc=function(r,A){switch(A){case 0:return eA(r.topLeftBorderDoubleInnerBox,r.topLeftPaddingBox,r.topRightBorderDoubleInnerBox,r.topRightPaddingBox);case 1:return eA(r.topRightBorderDoubleInnerBox,r.topRightPaddingBox,r.bottomRightBorderDoubleInnerBox,r.bottomRightPaddingBox);case 2:return eA(r.bottomRightBorderDoubleInnerBox,r.bottomRightPaddingBox,r.bottomLeftBorderDoubleInnerBox,r.bottomLeftPaddingBox);case 3:default:return eA(r.bottomLeftBorderDoubleInnerBox,r.bottomLeftPaddingBox,r.topLeftBorderDoubleInnerBox,r.topLeftPaddingBox)}},yc=function(r,A){switch(A){case 0:return Bt(r.topLeftBorderStroke,r.topRightBorderStroke);case 1:return Bt(r.topRightBorderStroke,r.bottomRightBorderStroke);case 2:return Bt(r.bottomRightBorderStroke,r.bottomLeftBorderStroke);case 3:default:return Bt(r.bottomLeftBorderStroke,r.topLeftBorderStroke)}},Bt=function(r,A){var e=[];return AA(r)?e.push(r.subdivide(.5,!1)):e.push(r),AA(A)?e.push(A.subdivide(.5,!0)):e.push(A),e},eA=function(r,A,e,t){var s=[];return AA(r)?s.push(r.subdivide(.5,!1)):s.push(r),AA(e)?s.push(e.subdivide(.5,!0)):s.push(e),AA(t)?s.push(t.subdivide(.5,!0).reverse()):s.push(t),AA(A)?s.push(A.subdivide(.5,!1).reverse()):s.push(A),s},cn=function(r){var A=r.bounds,e=r.styles;return A.add(e.borderLeftWidth,e.borderTopWidth,-(e.borderRightWidth+e.borderLeftWidth),-(e.borderTopWidth+e.borderBottomWidth))},ot=function(r){var A=r.styles,e=r.bounds,t=K(A.paddingLeft,e.width),s=K(A.paddingRight,e.width),n=K(A.paddingTop,e.width),a=K(A.paddingBottom,e.width);return e.add(t+A.borderLeftWidth,n+A.borderTopWidth,-(A.borderRightWidth+A.borderLeftWidth+t+s),-(A.borderTopWidth+A.borderBottomWidth+n+a))},mc=function(r,A){return r===0?A.bounds:r===2?ot(A):cn(A)},Ic=function(r,A){return r===0?A.bounds:r===2?ot(A):cn(A)},ir=function(r,A,e){var t=mc(WA(r.styles.backgroundOrigin,A),r),s=Ic(WA(r.styles.backgroundClip,A),r),n=bc(WA(r.styles.backgroundSize,A),e,t),a=n[0],B=n[1],i=oe(WA(r.styles.backgroundPosition,A),t.width-a,t.height-B),o=xc(WA(r.styles.backgroundRepeat,A),i,n,t,s),c=Math.round(t.left+i[0]),l=Math.round(t.top+i[1]);return[o,c,l,a,B]},JA=function(r){return x(r)&&r.value===VA.AUTO},ct=function(r){return typeof r=="number"},bc=function(r,A,e){var t=A[0],s=A[1],n=A[2],a=r[0],B=r[1];if(!a)return[0,0];if(O(a)&&B&&O(B))return[K(a,e.width),K(B,e.height)];var i=ct(n);if(x(a)&&(a.value===VA.CONTAIN||a.value===VA.COVER)){if(ct(n)){var o=e.width/e.height;return o<n!=(a.value===VA.COVER)?[e.width,e.width/n]:[e.height*n,e.height]}return[e.width,e.height]}var c=ct(t),l=ct(s),g=c||l;if(JA(a)&&(!B||JA(B))){if(c&&l)return[t,s];if(!i&&!g)return[e.width,e.height];if(g&&i){var f=c?t:s*n,u=l?s:t/n;return[f,u]}var w=c?t:e.width,v=l?s:e.height;return[w,v]}if(i){var U=0,h=0;return O(a)?U=K(a,e.width):O(B)&&(h=K(B,e.height)),JA(a)?U=h*n:(!B||JA(B))&&(h=U/n),[U,h]}var I=null,E=null;if(O(a)?I=K(a,e.width):B&&O(B)&&(E=K(B,e.height)),I!==null&&(!B||JA(B))&&(E=c&&l?I/t*s:e.height),E!==null&&JA(a)&&(I=c&&l?E/s*t:e.width),I!==null&&E!==null)return[I,E];throw new Error("Unable to calculate background-size for element")},WA=function(r,A){var e=r[A];return typeof e>"u"?r[0]:e},xc=function(r,A,e,t,s){var n=A[0],a=A[1],B=e[0],i=e[1];switch(r){case 2:return[new Q(Math.round(t.left),Math.round(t.top+a)),new Q(Math.round(t.left+t.width),Math.round(t.top+a)),new Q(Math.round(t.left+t.width),Math.round(i+t.top+a)),new Q(Math.round(t.left),Math.round(i+t.top+a))];case 3:return[new Q(Math.round(t.left+n),Math.round(t.top)),new Q(Math.round(t.left+n+B),Math.round(t.top)),new Q(Math.round(t.left+n+B),Math.round(t.height+t.top)),new Q(Math.round(t.left+n),Math.round(t.height+t.top))];case 1:return[new Q(Math.round(t.left+n),Math.round(t.top+a)),new Q(Math.round(t.left+n+B),Math.round(t.top+a)),new Q(Math.round(t.left+n+B),Math.round(t.top+a+i)),new Q(Math.round(t.left+n),Math.round(t.top+a+i))];default:return[new Q(Math.round(s.left),Math.round(s.top)),new Q(Math.round(s.left+s.width),Math.round(s.top)),new Q(Math.round(s.left+s.width),Math.round(s.height+s.top)),new Q(Math.round(s.left),Math.round(s.height+s.top))]}},Lc="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",ln="Hidden Text",Kc=(function(){function r(A){this._data={},this._document=A}return r.prototype.parseMetrics=function(A,e){var t=this._document.createElement("div"),s=this._document.createElement("img"),n=this._document.createElement("span"),a=this._document.body;t.style.visibility="hidden",t.style.fontFamily=A,t.style.fontSize=e,t.style.margin="0",t.style.padding="0",t.style.whiteSpace="nowrap",a.appendChild(t),s.src=Lc,s.width=1,s.height=1,s.style.margin="0",s.style.padding="0",s.style.verticalAlign="baseline",n.style.fontFamily=A,n.style.fontSize=e,n.style.margin="0",n.style.padding="0",n.appendChild(this._document.createTextNode(ln)),t.appendChild(n),t.appendChild(s);var B=s.offsetTop-n.offsetTop+2;t.removeChild(n),t.appendChild(this._document.createTextNode(ln)),t.style.lineHeight="normal",s.style.verticalAlign="super";var i=s.offsetTop-t.offsetTop+2;return a.removeChild(t),{baseline:B,middle:i}},r.prototype.getMetrics=function(A,e){var t=A+" "+e;return typeof this._data[t]>"u"&&(this._data[t]=this.parseMetrics(A,e)),this._data[t]},r})(),gn=(function(){function r(A,e){this.context=A,this.options=e}return r})(),Sc=1e4,Dc=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s._activeEffects=[],s.canvas=t.canvas?t.canvas:document.createElement("canvas"),s.ctx=s.canvas.getContext("2d"),t.canvas||(s.canvas.width=Math.floor(t.width*t.scale),s.canvas.height=Math.floor(t.height*t.scale),s.canvas.style.width=t.width+"px",s.canvas.style.height=t.height+"px"),s.fontMetrics=new Kc(document),s.ctx.scale(s.options.scale,s.options.scale),s.ctx.translate(-t.x,-t.y),s.ctx.textBaseline="bottom",s._activeEffects=[],s.context.logger.debug("Canvas renderer initialized ("+t.width+"x"+t.height+") with scale "+t.scale),s}return A.prototype.applyEffects=function(e){for(var t=this;this._activeEffects.length;)this.popEffect();e.forEach(function(s){return t.applyEffect(s)})},A.prototype.applyEffect=function(e){this.ctx.save(),Fc(e)&&(this.ctx.globalAlpha=e.opacity),Uc(e)&&(this.ctx.translate(e.offsetX,e.offsetY),this.ctx.transform(e.matrix[0],e.matrix[1],e.matrix[2],e.matrix[3],e.matrix[4],e.matrix[5]),this.ctx.translate(-e.offsetX,-e.offsetY)),rn(e)&&(this.path(e.path),this.ctx.clip()),this._activeEffects.push(e)},A.prototype.popEffect=function(){this._activeEffects.pop(),this.ctx.restore()},A.prototype.renderStack=function(e){return X(this,void 0,void 0,function(){var t;return P(this,function(s){switch(s.label){case 0:return t=e.element.container.styles,t.isVisible()?[4,this.renderStackContent(e)]:[3,2];case 1:s.sent(),s.label=2;case 2:return[2]}})})},A.prototype.renderNode=function(e){return X(this,void 0,void 0,function(){return P(this,function(t){switch(t.label){case 0:if(G(e.container.flags,16))debugger;return e.container.styles.isVisible()?[4,this.renderNodeBackgroundAndBorders(e)]:[3,3];case 1:return t.sent(),[4,this.renderNodeContent(e)];case 2:t.sent(),t.label=3;case 3:return[2]}})})},A.prototype.renderTextWithLetterSpacing=function(e,t,s){var n=this;if(t===0)this.ctx.fillText(e.text,e.bounds.left,e.bounds.top+s);else{var a=Yt(e.text);a.reduce(function(B,i){return n.ctx.fillText(i,B,e.bounds.top+s),B+n.ctx.measureText(i).width},e.bounds.left)}},A.prototype.createFontStyle=function(e){var t=e.fontVariant.filter(function(a){return a==="normal"||a==="small-caps"}).join(""),s=kc(e.fontFamily).join(", "),n=Be(e.fontSize)?""+e.fontSize.number+e.fontSize.unit:e.fontSize.number+"px";return[[e.fontStyle,t,e.fontWeight,n,s].join(" "),s,n]},A.prototype.renderTextNode=function(e,t){return X(this,void 0,void 0,function(){var s,n,a,B,i,o,c,l,g=this;return P(this,function(f){return s=this.createFontStyle(t),n=s[0],a=s[1],B=s[2],this.ctx.font=n,this.ctx.direction=t.direction===1?"rtl":"ltr",this.ctx.textAlign="left",this.ctx.textBaseline="alphabetic",i=this.fontMetrics.getMetrics(a,B),o=i.baseline,c=i.middle,l=t.paintOrder,e.textBounds.forEach(function(u){l.forEach(function(w){switch(w){case 0:g.ctx.fillStyle=k(t.color),g.renderTextWithLetterSpacing(u,t.letterSpacing,o);var v=t.textShadow;v.length&&u.text.trim().length&&(v.slice(0).reverse().forEach(function(U){g.ctx.shadowColor=k(U.color),g.ctx.shadowOffsetX=U.offsetX.number*g.options.scale,g.ctx.shadowOffsetY=U.offsetY.number*g.options.scale,g.ctx.shadowBlur=U.blur.number,g.renderTextWithLetterSpacing(u,t.letterSpacing,o)}),g.ctx.shadowColor="",g.ctx.shadowOffsetX=0,g.ctx.shadowOffsetY=0,g.ctx.shadowBlur=0),t.textDecorationLine.length&&(g.ctx.fillStyle=k(t.textDecorationColor||t.color),t.textDecorationLine.forEach(function(U){switch(U){case 1:g.ctx.fillRect(u.bounds.left,Math.round(u.bounds.top+o),u.bounds.width,1);break;case 2:g.ctx.fillRect(u.bounds.left,Math.round(u.bounds.top),u.bounds.width,1);break;case 3:g.ctx.fillRect(u.bounds.left,Math.ceil(u.bounds.top+c),u.bounds.width,1);break}}));break;case 1:t.webkitTextStrokeWidth&&u.text.trim().length&&(g.ctx.strokeStyle=k(t.webkitTextStrokeColor),g.ctx.lineWidth=t.webkitTextStrokeWidth,g.ctx.lineJoin=window.chrome?"miter":"round",g.ctx.strokeText(u.text,u.bounds.left,u.bounds.top+o)),g.ctx.strokeStyle="",g.ctx.lineWidth=0,g.ctx.lineJoin="miter";break}})}),[2]})})},A.prototype.renderReplacedElement=function(e,t,s){if(s&&e.intrinsicWidth>0&&e.intrinsicHeight>0){var n=ot(e),a=at(t);this.path(a),this.ctx.save(),this.ctx.clip(),this.ctx.drawImage(s,0,0,e.intrinsicWidth,e.intrinsicHeight,n.left,n.top,n.width,n.height),this.ctx.restore()}},A.prototype.renderNodeContent=function(e){return X(this,void 0,void 0,function(){var t,s,n,a,B,i,h,h,o,c,l,g,E,f,u,F,w,v,U,h,I,E,F;return P(this,function(d){switch(d.label){case 0:this.applyEffects(e.getEffects(4)),t=e.container,s=e.curves,n=t.styles,a=0,B=t.textNodes,d.label=1;case 1:return a<B.length?(i=B[a],[4,this.renderTextNode(i,n)]):[3,4];case 2:d.sent(),d.label=3;case 3:return a++,[3,1];case 4:if(!(t instanceof bs))return[3,8];d.label=5;case 5:return d.trys.push([5,7,,8]),[4,this.context.cache.match(t.src)];case 6:return h=d.sent(),this.renderReplacedElement(t,s,h),[3,8];case 7:return d.sent(),this.context.logger.error("Error loading image "+t.src),[3,8];case 8:if(t instanceof xs&&this.renderReplacedElement(t,s,t.canvas),!(t instanceof Ls))return[3,12];d.label=9;case 9:return d.trys.push([9,11,,12]),[4,this.context.cache.match(t.svg)];case 10:return h=d.sent(),this.renderReplacedElement(t,s,h),[3,12];case 11:return d.sent(),this.context.logger.error("Error loading svg "+t.svg.substring(0,255)),[3,12];case 12:return t instanceof Os&&t.tree?(o=new A(this.context,{scale:this.options.scale,backgroundColor:t.backgroundColor,x:0,y:0,width:t.width,height:t.height}),[4,o.render(t.tree)]):[3,14];case 13:c=d.sent(),t.width&&t.height&&this.ctx.drawImage(c,0,0,t.width,t.height,t.bounds.left,t.bounds.top,t.bounds.width,t.bounds.height),d.label=14;case 14:if(t instanceof qt&&(l=Math.min(t.bounds.width,t.bounds.height),t.type===$e?t.checked&&(this.ctx.save(),this.path([new Q(t.bounds.left+l*.39363,t.bounds.top+l*.79),new Q(t.bounds.left+l*.16,t.bounds.top+l*.5549),new Q(t.bounds.left+l*.27347,t.bounds.top+l*.44071),new Q(t.bounds.left+l*.39694,t.bounds.top+l*.5649),new Q(t.bounds.left+l*.72983,t.bounds.top+l*.23),new Q(t.bounds.left+l*.84,t.bounds.top+l*.34085),new Q(t.bounds.left+l*.39363,t.bounds.top+l*.79)]),this.ctx.fillStyle=k(Ss),this.ctx.fill(),this.ctx.restore()):t.type===ze&&t.checked&&(this.ctx.save(),this.ctx.beginPath(),this.ctx.arc(t.bounds.left+l/2,t.bounds.top+l/2,l/4,0,Math.PI*2,!0),this.ctx.fillStyle=k(Ss),this.ctx.fill(),this.ctx.restore())),Tc(t)&&t.value.length){switch(g=this.createFontStyle(n),E=g[0],f=g[1],u=this.fontMetrics.getMetrics(E,f).baseline,this.ctx.font=E,this.ctx.fillStyle=k(n.color),this.ctx.textBaseline="alphabetic",this.ctx.textAlign=Mc(t.styles.textAlign),F=ot(t),w=0,t.styles.textAlign){case 1:w+=F.width/2;break;case 2:w+=F.width;break}v=F.add(w,0,0,-F.height/2+1),this.ctx.save(),this.path([new Q(F.left,F.top),new Q(F.left+F.width,F.top),new Q(F.left+F.width,F.top+F.height),new Q(F.left,F.top+F.height)]),this.ctx.clip(),this.renderTextWithLetterSpacing(new ue(t.value,v),n.letterSpacing,u),this.ctx.restore(),this.ctx.textBaseline="alphabetic",this.ctx.textAlign="left"}if(!G(t.styles.display,2048))return[3,20];if(t.styles.listStyleImage===null)return[3,19];if(U=t.styles.listStyleImage,U.type!==0)return[3,18];h=void 0,I=U.url,d.label=15;case 15:return d.trys.push([15,17,,18]),[4,this.context.cache.match(I)];case 16:return h=d.sent(),this.ctx.drawImage(h,t.bounds.left-(h.width+10),t.bounds.top),[3,18];case 17:return d.sent(),this.context.logger.error("Error loading list-style-image "+I),[3,18];case 18:return[3,20];case 19:e.listValue&&t.styles.listStyleType!==-1&&(E=this.createFontStyle(n)[0],this.ctx.font=E,this.ctx.fillStyle=k(n.color),this.ctx.textBaseline="middle",this.ctx.textAlign="right",F=new BA(t.bounds.left,t.bounds.top+K(t.styles.paddingTop,t.bounds.width),t.bounds.width,cs(n.lineHeight,n.fontSize.number)/2+1),this.renderTextWithLetterSpacing(new ue(e.listValue,F),n.letterSpacing,cs(n.lineHeight,n.fontSize.number)/2+2),this.ctx.textBaseline="bottom",this.ctx.textAlign="left"),d.label=20;case 20:return[2]}})})},A.prototype.renderStackContent=function(e){return X(this,void 0,void 0,function(){var t,s,U,n,a,U,B,i,U,o,c,U,l,g,U,f,u,U,w,v,U;return P(this,function(h){switch(h.label){case 0:if(G(e.element.container.flags,16))debugger;return[4,this.renderNodeBackgroundAndBorders(e.element)];case 1:h.sent(),t=0,s=e.negativeZIndex,h.label=2;case 2:return t<s.length?(U=s[t],[4,this.renderStack(U)]):[3,5];case 3:h.sent(),h.label=4;case 4:return t++,[3,2];case 5:return[4,this.renderNodeContent(e.element)];case 6:h.sent(),n=0,a=e.nonInlineLevel,h.label=7;case 7:return n<a.length?(U=a[n],[4,this.renderNode(U)]):[3,10];case 8:h.sent(),h.label=9;case 9:return n++,[3,7];case 10:B=0,i=e.nonPositionedFloats,h.label=11;case 11:return B<i.length?(U=i[B],[4,this.renderStack(U)]):[3,14];case 12:h.sent(),h.label=13;case 13:return B++,[3,11];case 14:o=0,c=e.nonPositionedInlineLevel,h.label=15;case 15:return o<c.length?(U=c[o],[4,this.renderStack(U)]):[3,18];case 16:h.sent(),h.label=17;case 17:return o++,[3,15];case 18:l=0,g=e.inlineLevel,h.label=19;case 19:return l<g.length?(U=g[l],[4,this.renderNode(U)]):[3,22];case 20:h.sent(),h.label=21;case 21:return l++,[3,19];case 22:f=0,u=e.zeroOrAutoZIndexOrTransformedOrOpacity,h.label=23;case 23:return f<u.length?(U=u[f],[4,this.renderStack(U)]):[3,26];case 24:h.sent(),h.label=25;case 25:return f++,[3,23];case 26:w=0,v=e.positiveZIndex,h.label=27;case 27:return w<v.length?(U=v[w],[4,this.renderStack(U)]):[3,30];case 28:h.sent(),h.label=29;case 29:return w++,[3,27];case 30:return[2]}})})},A.prototype.mask=function(e){this.ctx.beginPath(),this.ctx.moveTo(0,0),this.ctx.lineTo(this.canvas.width,0),this.ctx.lineTo(this.canvas.width,this.canvas.height),this.ctx.lineTo(0,this.canvas.height),this.ctx.lineTo(0,0),this.formatPath(e.slice(0).reverse()),this.ctx.closePath()},A.prototype.path=function(e){this.ctx.beginPath(),this.formatPath(e),this.ctx.closePath()},A.prototype.formatPath=function(e){var t=this;e.forEach(function(s,n){var a=AA(s)?s.start:s;n===0?t.ctx.moveTo(a.x,a.y):t.ctx.lineTo(a.x,a.y),AA(s)&&t.ctx.bezierCurveTo(s.startControl.x,s.startControl.y,s.endControl.x,s.endControl.y,s.end.x,s.end.y)})},A.prototype.renderRepeat=function(e,t,s,n){this.path(e),this.ctx.fillStyle=t,this.ctx.translate(s,n),this.ctx.fill(),this.ctx.translate(-s,-n)},A.prototype.resizeImage=function(e,t,s){var n;if(e.width===t&&e.height===s)return e;var a=(n=this.canvas.ownerDocument)!==null&&n!==void 0?n:document,B=a.createElement("canvas");B.width=Math.max(1,t),B.height=Math.max(1,s);var i=B.getContext("2d");return i.drawImage(e,0,0,e.width,e.height,0,0,t,s),B},A.prototype.renderBackgroundImage=function(e){return X(this,void 0,void 0,function(){var t,s,n,a,B,i;return P(this,function(o){switch(o.label){case 0:t=e.styles.backgroundImage.length-1,s=function(c){var l,g,f,M,Y,Z,L,N,m,u,M,Y,Z,L,N,w,v,U,h,I,E,F,d,y,m,p,M,W,j,L,N,vA,Y,Z,LA,iA,EA,KA,SA,gA,DA,uA;return P(this,function(YA){switch(YA.label){case 0:if(c.type!==0)return[3,5];l=void 0,g=c.url,YA.label=1;case 1:return YA.trys.push([1,3,,4]),[4,n.context.cache.match(g)];case 2:return l=YA.sent(),[3,4];case 3:return YA.sent(),n.context.logger.error("Error loading background-image "+g),[3,4];case 4:return l&&(f=ir(e,t,[l.width,l.height,l.width/l.height]),M=f[0],Y=f[1],Z=f[2],L=f[3],N=f[4],m=n.ctx.createPattern(n.resizeImage(l,L,N),"repeat"),n.renderRepeat(M,m,Y,Z)),[3,6];case 5:hi(c)?(u=ir(e,t,[null,null,null]),M=u[0],Y=u[1],Z=u[2],L=u[3],N=u[4],w=wi(c.angle,L,N),v=w[0],U=w[1],h=w[2],I=w[3],E=w[4],F=document.createElement("canvas"),F.width=L,F.height=N,d=F.getContext("2d"),y=d.createLinearGradient(U,I,h,E),zr(c.stops,v).forEach(function(fe){return y.addColorStop(fe.stop,k(fe.color))}),d.fillStyle=y,d.fillRect(0,0,L,N),L>0&&N>0&&(m=n.ctx.createPattern(F,"repeat"),n.renderRepeat(M,m,Y,Z))):Ui(c)&&(p=ir(e,t,[null,null,null]),M=p[0],W=p[1],j=p[2],L=p[3],N=p[4],vA=c.position.length===0?[St]:c.position,Y=K(vA[0],L),Z=K(vA[vA.length-1],N),LA=Qi(c,Y,Z,L,N),iA=LA[0],EA=LA[1],iA>0&&EA>0&&(KA=n.ctx.createRadialGradient(W+Y,j+Z,0,W+Y,j+Z,iA),zr(c.stops,iA*2).forEach(function(fe){return KA.addColorStop(fe.stop,k(fe.color))}),n.path(M),n.ctx.fillStyle=KA,iA!==EA?(SA=e.bounds.left+.5*e.bounds.width,gA=e.bounds.top+.5*e.bounds.height,DA=EA/iA,uA=1/DA,n.ctx.save(),n.ctx.translate(SA,gA),n.ctx.transform(1,0,0,DA,0,0),n.ctx.translate(-SA,-gA),n.ctx.fillRect(W,uA*(j-gA)+gA,L,N*uA),n.ctx.restore()):n.ctx.fill())),YA.label=6;case 6:return t--,[2]}})},n=this,a=0,B=e.styles.backgroundImage.slice(0).reverse(),o.label=1;case 1:return a<B.length?(i=B[a],[5,s(i)]):[3,4];case 2:o.sent(),o.label=3;case 3:return a++,[3,1];case 4:return[2]}})})},A.prototype.renderSolidBorder=function(e,t,s){return X(this,void 0,void 0,function(){return P(this,function(n){return this.path(on(s,t)),this.ctx.fillStyle=k(e),this.ctx.fill(),[2]})})},A.prototype.renderDoubleBorder=function(e,t,s,n){return X(this,void 0,void 0,function(){var a,B;return P(this,function(i){switch(i.label){case 0:return t<3?[4,this.renderSolidBorder(e,s,n)]:[3,2];case 1:return i.sent(),[2];case 2:return a=Ec(n,s),this.path(a),this.ctx.fillStyle=k(e),this.ctx.fill(),B=Hc(n,s),this.path(B),this.ctx.fill(),[2]}})})},A.prototype.renderNodeBackgroundAndBorders=function(e){return X(this,void 0,void 0,function(){var t,s,n,a,B,i,o,c,l=this;return P(this,function(g){switch(g.label){case 0:return this.applyEffects(e.getEffects(2)),t=e.container.styles,s=!hA(t.backgroundColor)||t.backgroundImage.length,n=[{style:t.borderTopStyle,color:t.borderTopColor,width:t.borderTopWidth},{style:t.borderRightStyle,color:t.borderRightColor,width:t.borderRightWidth},{style:t.borderBottomStyle,color:t.borderBottomColor,width:t.borderBottomWidth},{style:t.borderLeftStyle,color:t.borderLeftColor,width:t.borderLeftWidth}],a=Oc(WA(t.backgroundClip,0),e.curves),s||t.boxShadow.length?(this.ctx.save(),this.path(a),this.ctx.clip(),hA(t.backgroundColor)||(this.ctx.fillStyle=k(t.backgroundColor),this.ctx.fill()),[4,this.renderBackgroundImage(e.container)]):[3,2];case 1:g.sent(),this.ctx.restore(),t.boxShadow.slice(0).reverse().forEach(function(f){l.ctx.save();var u=nt(e.curves),w=f.inset?0:Sc,v=pc(u,-w+(f.inset?1:-1)*f.spread.number,(f.inset?1:-1)*f.spread.number,f.spread.number*(f.inset?-2:2),f.spread.number*(f.inset?-2:2));f.inset?(l.path(u),l.ctx.clip(),l.mask(v)):(l.mask(u),l.ctx.clip(),l.path(v)),l.ctx.shadowOffsetX=f.offsetX.number+w,l.ctx.shadowOffsetY=f.offsetY.number,l.ctx.shadowColor=k(f.color),l.ctx.shadowBlur=f.blur.number,l.ctx.fillStyle=f.inset?k(f.color):"rgba(0,0,0,1)",l.ctx.fill(),l.ctx.restore()}),g.label=2;case 2:B=0,i=0,o=n,g.label=3;case 3:return i<o.length?(c=o[i],c.style!==0&&!hA(c.color)&&c.width>0?c.style!==2?[3,5]:[4,this.renderDashedDottedBorder(c.color,c.width,B,e.curves,2)]:[3,11]):[3,13];case 4:return g.sent(),[3,11];case 5:return c.style!==3?[3,7]:[4,this.renderDashedDottedBorder(c.color,c.width,B,e.curves,3)];case 6:return g.sent(),[3,11];case 7:return c.style!==4?[3,9]:[4,this.renderDoubleBorder(c.color,c.width,B,e.curves)];case 8:return g.sent(),[3,11];case 9:return[4,this.renderSolidBorder(c.color,B,e.curves)];case 10:g.sent(),g.label=11;case 11:B++,g.label=12;case 12:return i++,[3,3];case 13:return[2]}})})},A.prototype.renderDashedDottedBorder=function(e,t,s,n,a){return X(this,void 0,void 0,function(){var B,i,o,c,l,g,f,u,w,v,U,h,I,E,F,d,F,d;return P(this,function(y){return this.ctx.save(),B=yc(n,s),i=on(n,s),a===2&&(this.path(i),this.ctx.clip()),AA(i[0])?(o=i[0].start.x,c=i[0].start.y):(o=i[0].x,c=i[0].y),AA(i[1])?(l=i[1].end.x,g=i[1].end.y):(l=i[1].x,g=i[1].y),s===0||s===2?f=Math.abs(o-l):f=Math.abs(c-g),this.ctx.beginPath(),a===3?this.formatPath(B):this.formatPath(i.slice(0,2)),u=t<3?t*3:t*2,w=t<3?t*2:t,a===3&&(u=t,w=t),v=!0,f<=u*2?v=!1:f<=u*2+w?(U=f/(2*u+w),u*=U,w*=U):(h=Math.floor((f+w)/(u+w)),I=(f-h*u)/(h-1),E=(f-(h+1)*u)/h,w=E<=0||Math.abs(w-I)<Math.abs(w-E)?I:E),v&&(a===3?this.ctx.setLineDash([0,u+w]):this.ctx.setLineDash([u,w])),a===3?(this.ctx.lineCap="round",this.ctx.lineWidth=t):this.ctx.lineWidth=t*2+1.1,this.ctx.strokeStyle=k(e),this.ctx.stroke(),this.ctx.setLineDash([]),a===2&&(AA(i[0])&&(F=i[3],d=i[0],this.ctx.beginPath(),this.formatPath([new Q(F.end.x,F.end.y),new Q(d.start.x,d.start.y)]),this.ctx.stroke()),AA(i[1])&&(F=i[1],d=i[2],this.ctx.beginPath(),this.formatPath([new Q(F.end.x,F.end.y),new Q(d.start.x,d.start.y)]),this.ctx.stroke())),this.ctx.restore(),[2]})})},A.prototype.render=function(e){return X(this,void 0,void 0,function(){var t;return P(this,function(s){switch(s.label){case 0:return this.options.backgroundColor&&(this.ctx.fillStyle=k(this.options.backgroundColor),this.ctx.fillRect(this.options.x,this.options.y,this.options.width,this.options.height)),t=vc(e),[4,this.renderStack(t)];case 1:return s.sent(),this.applyEffects([]),[2,this.canvas]}})})},A})(gn),Tc=function(r){return r instanceof Ts||r instanceof Ds?!0:r instanceof qt&&r.type!==ze&&r.type!==$e},Oc=function(r,A){switch(r){case 0:return nt(A);case 2:return fc(A);case 1:default:return at(A)}},Mc=function(r){switch(r){case 1:return"center";case 2:return"right";case 0:default:return"left"}},Gc=["-apple-system","system-ui"],kc=function(r){return/iPhone OS 15_(0|1)/.test(window.navigator.userAgent)?r.filter(function(A){return Gc.indexOf(A)===-1}):r},Rc=(function(r){tA(A,r);function A(e,t){var s=r.call(this,e,t)||this;return s.canvas=t.canvas?t.canvas:document.createElement("canvas"),s.ctx=s.canvas.getContext("2d"),s.options=t,s.canvas.width=Math.floor(t.width*t.scale),s.canvas.height=Math.floor(t.height*t.scale),s.canvas.style.width=t.width+"px",s.canvas.style.height=t.height+"px",s.ctx.scale(s.options.scale,s.options.scale),s.ctx.translate(-t.x,-t.y),s.context.logger.debug("EXPERIMENTAL ForeignObject renderer initialized ("+t.width+"x"+t.height+" at "+t.x+","+t.y+") with scale "+t.scale),s}return A.prototype.render=function(e){return X(this,void 0,void 0,function(){var t,s;return P(this,function(n){switch(n.label){case 0:return t=Wt(this.options.width*this.options.scale,this.options.height*this.options.scale,this.options.scale,this.options.scale,e),[4,Vc(t)];case 1:return s=n.sent(),this.options.backgroundColor&&(this.ctx.fillStyle=k(this.options.backgroundColor),this.ctx.fillRect(0,0,this.options.width*this.options.scale,this.options.height*this.options.scale)),this.ctx.drawImage(s,-this.options.x*this.options.scale,-this.options.y*this.options.scale),[2,this.canvas]}})})},A})(gn),Vc=function(r){return new Promise(function(A,e){var t=new Image;t.onload=function(){A(t)},t.onerror=e,t.src="data:image/svg+xml;charset=utf-8,"+encodeURIComponent(new XMLSerializer().serializeToString(r))})},Nc=(function(){function r(A){var e=A.id,t=A.enabled;this.id=e,this.enabled=t,this.start=Date.now()}return r.prototype.debug=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&(typeof window<"u"&&window.console&&typeof console.debug=="function"?console.debug.apply(console,Ce([this.id,this.getTime()+"ms"],A)):this.info.apply(this,A))},r.prototype.getTime=function(){return Date.now()-this.start},r.prototype.info=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&typeof window<"u"&&window.console&&typeof console.info=="function"&&console.info.apply(console,Ce([this.id,this.getTime()+"ms"],A))},r.prototype.warn=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&(typeof window<"u"&&window.console&&typeof console.warn=="function"?console.warn.apply(console,Ce([this.id,this.getTime()+"ms"],A)):this.info.apply(this,A))},r.prototype.error=function(){for(var A=[],e=0;e<arguments.length;e++)A[e]=arguments[e];this.enabled&&(typeof window<"u"&&window.console&&typeof console.error=="function"?console.error.apply(console,Ce([this.id,this.getTime()+"ms"],A)):this.info.apply(this,A))},r.instances={},r})(),Pc=(function(){function r(A,e){var t;this.windowBounds=e,this.instanceName="#"+r.instanceCount++,this.logger=new Nc({id:this.instanceName,enabled:A.logging}),this.cache=(t=A.cache)!==null&&t!==void 0?t:new oc(this,A)}return r.instanceCount=1,r})(),_c=function(r,A){return A===void 0&&(A={}),Xc(r,A)};typeof window<"u"&&tn.setContext(window);var Xc=function(r,A){return X(void 0,void 0,void 0,function(){var e,t,s,n,a,B,i,o,c,l,g,f,u,w,v,U,h,I,E,F,y,d,y,m,p,M,W,j,L,N,vA,Y,Z,LA,iA,EA,KA,SA,gA,DA;return P(this,function(uA){switch(uA.label){case 0:if(!r||typeof r!="object")return[2,Promise.reject("Invalid element provided as first argument")];if(e=r.ownerDocument,!e)throw new Error("Element is not attached to a Document");if(t=e.defaultView,!t)throw new Error("Document is not attached to a Window");return s={allowTaint:(m=A.allowTaint)!==null&&m!==void 0?m:!1,imageTimeout:(p=A.imageTimeout)!==null&&p!==void 0?p:15e3,proxy:A.proxy,useCORS:(M=A.useCORS)!==null&&M!==void 0?M:!1},n=gt({logging:(W=A.logging)!==null&&W!==void 0?W:!0,cache:A.cache},s),a={windowWidth:(j=A.windowWidth)!==null&&j!==void 0?j:t.innerWidth,windowHeight:(L=A.windowHeight)!==null&&L!==void 0?L:t.innerHeight,scrollX:(N=A.scrollX)!==null&&N!==void 0?N:t.pageXOffset,scrollY:(vA=A.scrollY)!==null&&vA!==void 0?vA:t.pageYOffset},B=new BA(a.scrollX,a.scrollY,a.windowWidth,a.windowHeight),i=new Pc(n,B),o=(Y=A.foreignObjectRendering)!==null&&Y!==void 0?Y:!1,c={allowTaint:(Z=A.allowTaint)!==null&&Z!==void 0?Z:!1,onclone:A.onclone,ignoreElements:A.ignoreElements,inlineImages:o,copyStyles:o},i.logger.debug("Starting document clone with size "+B.width+"x"+B.height+" scrolled to "+-B.left+","+-B.top),l=new An(i,r,c),g=l.clonedReferenceElement,g?[4,l.toIFrame(e,B)]:[2,Promise.reject("Unable to find element in cloned iframe")];case 1:return f=uA.sent(),u=$t(g)||Jo(g)?Fn(g.ownerDocument):he(i,g),w=u.width,v=u.height,U=u.left,h=u.top,I=Jc(i,g,A.backgroundColor),E={canvas:A.canvas,backgroundColor:I,scale:(iA=(LA=A.scale)!==null&&LA!==void 0?LA:t.devicePixelRatio)!==null&&iA!==void 0?iA:1,x:((EA=A.x)!==null&&EA!==void 0?EA:0)+U,y:((KA=A.y)!==null&&KA!==void 0?KA:0)+h,width:(SA=A.width)!==null&&SA!==void 0?SA:Math.ceil(w),height:(gA=A.height)!==null&&gA!==void 0?gA:Math.ceil(v)},o?(i.logger.debug("Document cloned, using foreign object rendering"),y=new Rc(i,E),[4,y.render(g)]):[3,3];case 2:return F=uA.sent(),[3,5];case 3:return i.logger.debug("Document cloned, element located at "+U+","+h+" with size "+w+"x"+v+" using computed rendering"),i.logger.debug("Starting DOM parsing"),d=Gs(i,g),I===d.styles.backgroundColor&&(d.styles.backgroundColor=cA.TRANSPARENT),i.logger.debug("Starting renderer for element at "+E.x+","+E.y+" with size "+E.width+"x"+E.height),y=new Dc(i,E),[4,y.render(d)];case 4:F=uA.sent(),uA.label=5;case 5:return(!((DA=A.removeContainer)!==null&&DA!==void 0)||DA)&&(An.destroy(f)||i.logger.error("Cannot detach cloned iframe as it is not in the DOM anymore")),i.logger.debug("Finished rendering"),[2,F]}})})},Jc=function(r,A,e){var t=A.ownerDocument,s=t.documentElement?ce(r,getComputedStyle(t.documentElement).backgroundColor):cA.TRANSPARENT,n=t.body?ce(r,getComputedStyle(t.body).backgroundColor):cA.TRANSPARENT,a=typeof e=="string"?ce(r,e):e===null?cA.TRANSPARENT:4294967295;return A===t.documentElement?hA(s)?hA(n)?a:n:s:a};const Wc=Object.freeze(Object.defineProperty({__proto__:null,default:_c},Symbol.toStringTag,{value:"Module"}));HA.FCOSOrchidJudgeWidget=Br,HA.default=or,Object.defineProperties(HA,{__esModule:{value:!0},[Symbol.toStringTag]:{value:"Module"}})}));
