from sqlalchemy import Column, Integer, String, Text, Boolean, DateTime, Float, ForeignKey, Date, ARRAY
from sqlalchemy.dialects.postgresql import JSONB
from sqlalchemy.orm import relationship
from database import Base

# Adapter models for existing database schema
class OrchidRecord(Base):
    __tablename__ = "orchid_record"
    
    id = Column(Integer, primary_key=True)
    taxonomy_id = Column(Integer, nullable=True)
    display_name = Column(String, nullable=True)
    scientific_name = Column(String, nullable=True)
    genus = Column(String, nullable=True)
    species = Column(String, nullable=True)
    author = Column(String, nullable=True)
    region = Column(String, nullable=True)
    native_habitat = Column(Text, nullable=True)
    bloom_time = Column(String, nullable=True)
    growth_habit = Column(String, nullable=True)
    climate_preference = Column(String, nullable=True)
    leaf_form = Column(String, nullable=True)
    pseudobulb_presence = Column(Boolean, nullable=True)
    light_requirements = Column(String, nullable=True)
    temperature_range = Column(String, nullable=True)
    water_requirements = Column(Text, nullable=True)
    fertilizer_needs = Column(Text, nullable=True)
    cultural_notes = Column(Text, nullable=True)
    image_filename = Column(String, nullable=True)
    image_url = Column(String, nullable=True)
    google_drive_id = Column(String, nullable=True)
    photographer = Column(String, nullable=True)
    image_source = Column(String, nullable=True)
    ocr_text = Column(Text, nullable=True)
    ai_description = Column(Text, nullable=True)
    ai_confidence = Column(Float, nullable=True)
    ai_extracted_metadata = Column(Text, nullable=True)
    ingestion_source = Column(String, nullable=True)
    validation_status = Column(String, nullable=True)
    is_featured = Column(Boolean, nullable=True)
    view_count = Column(Integer, nullable=True)
    created_at = Column(DateTime, nullable=True)
    updated_at = Column(DateTime, nullable=True)
    user_id = Column(Integer, nullable=True)
    rhs_registration_id = Column(String, nullable=True)
    is_hybrid = Column(Boolean, nullable=True)
    is_species = Column(Boolean, nullable=True)
    grex_name = Column(String, nullable=True)
    clone_name = Column(String, nullable=True)
    pod_parent = Column(String, nullable=True)
    pollen_parent = Column(String, nullable=True)
    parentage_formula = Column(String, nullable=True)
    generation = Column(Integer, nullable=True)
    registration_date = Column(DateTime, nullable=True)
    registrant = Column(String, nullable=True)
    rhs_verification_status = Column(String, nullable=True)
    enhancement_data = Column(Text, nullable=True)
    pollinator_types = Column(ARRAY(String), nullable=True)
    flowering_time = Column(String, nullable=True)
    mycorrhizal_fungi = Column(ARRAY(String), nullable=True)
    is_fragrant = Column(Boolean, nullable=True)
    photo_date = Column(Date, nullable=True)
    continent = Column(String, nullable=True)
    climate_zone = Column(String, nullable=True)
    phenotype_variations = Column(ARRAY(String), nullable=True)
    morphological_traits = Column(JSONB, nullable=True)
    variation_analysis = Column(JSONB, nullable=True)
    mutation_indicators = Column(ARRAY(String), nullable=True)
    phenotype_confidence = Column(Float, nullable=True)
    common_names = Column(Text, nullable=True)
    name_derivation = Column(Text, nullable=True)
    native_distribution = Column(Text, nullable=True)
    environmental_zones = Column(Text, nullable=True)
    leaf_shape = Column(String, nullable=True)
    leaf_description = Column(Text, nullable=True)
    flower_description = Column(Text, nullable=True)
    plant_size = Column(String, nullable=True)
    botanical_features = Column(Text, nullable=True)
    decimal_latitude = Column(Float, nullable=True)
    decimal_longitude = Column(Float, nullable=True)
    country = Column(String, nullable=True)
    collector = Column(String, nullable=True)
    event_date = Column(String, nullable=True)
    data_source = Column(String, nullable=True)
    state_province = Column(String, nullable=True)
    locality = Column(String, nullable=True)
    collection_number = Column(String, nullable=True)
    gbif_id = Column(String, nullable=True)
    source_url = Column(String, nullable=True)

class OrchidTaxonomy(Base):
    __tablename__ = "orchid_taxonomy"
    
    id = Column(Integer, primary_key=True)
    kingdom = Column(String, nullable=True)
    phylum = Column(String, nullable=True)
    class_name = Column("class", String, nullable=True)
    order = Column(String, nullable=True)
    family = Column(String, nullable=True)
    subfamily = Column(String, nullable=True)
    tribe = Column(String, nullable=True)
    subtribe = Column(String, nullable=True)
    genus = Column(String, nullable=False)
    species = Column(String, nullable=True)
    infraspecies = Column(String, nullable=True)
    created_at = Column(DateTime, nullable=True)
    updated_at = Column(DateTime, nullable=True)