import { FCOSOrchidJudgeWidget } from '../widget'

export class AboutView {
  constructor(private widget: FCOSOrchidJudgeWidget) {}

  render(): string {
    return `
      <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center gap-3 mb-6">
          <button class="btn btn-outline" data-action="back">← Back</button>
          <h2 class="text-xl font-bold text-gray-900 dark:text-white">About</h2>
        </div>

        <!-- Educational Tool Badge -->
        <div class="text-center">
          <div class="inline-block px-4 py-2 bg-blue-100 dark:bg-blue-900/30 text-blue-800 dark:text-blue-200 rounded-full text-sm font-medium mb-4">
            Educational Tool (Beta)
          </div>
        </div>

        <!-- FCOS Mission -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Five Cities Orchid Society Mission
          </h3>
          <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
            The Five Cities Orchid Society is dedicated to promoting the appreciation, 
            cultivation, and conservation of orchids through education, research, and community engagement. 
            We believe in making orchid knowledge accessible to everyone, from beginners to experts.
          </p>
        </div>

        <!-- Features -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Widget Features
          </h3>
          <div class="space-y-2 text-sm">
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Mobile-first responsive design</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">AI-powered image analysis and OCR</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Multiple international judging systems</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Comprehensive entry history and tracking</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Offline-first with optional cloud sync</span>
            </div>
            <div class="flex items-center gap-2">
              <span class="w-2 h-2 bg-primary-500 rounded-full"></span>
              <span class="text-gray-600 dark:text-gray-400">Professional certificate generation</span>
            </div>
          </div>
        </div>

        <!-- Important Disclaimer -->
        <div class="card bg-amber-50 dark:bg-amber-900/20 border-amber-200 dark:border-amber-800">
          <div class="flex items-start gap-3">
            <div class="text-amber-600 dark:text-amber-400 mt-1 text-lg">⚠️</div>
            <div>
              <h3 class="font-semibold text-amber-800 dark:text-amber-200 mb-2">
                Important Disclaimer
              </h3>
              <div class="text-sm text-amber-700 dark:text-amber-300 space-y-2">
                <p>
                  <strong>This is an educational tool for practice and learning purposes only.</strong>
                </p>
                <p>
                  This application is not affiliated with, endorsed by, or approved by the American Orchid Society (AOS), 
                  Australian Orchid Council (AOC), Orchid Society of New Zealand (OSNZ), Royal Horticultural Society (RHS), 
                  or any other official orchid judging organization.
                </p>
                <p>
                  Results, scores, and awards generated by this tool are for educational practice only and 
                  have no official recognition or validity for actual orchid judging competitions.
                </p>
                <p>
                  For official orchid judging, please contact your local orchid society or 
                  authorized judging centers recognized by official organizations.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Version & Technical Info -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Technical Information
          </h3>
          <div class="text-sm text-gray-600 dark:text-gray-400 space-y-1">
            <div class="flex justify-between">
              <span>Version:</span>
              <span>1.0.0 (Beta)</span>
            </div>
            <div class="flex justify-between">
              <span>Last Updated:</span>
              <span>${new Date().toLocaleDateString()}</span>
            </div>
            <div class="flex justify-between">
              <span>Data Storage:</span>
              <span>Local Device + Optional Cloud</span>
            </div>
            <div class="flex justify-between">
              <span>AI Provider:</span>
              <span id="ai-provider-display">Configurable</span>
            </div>
          </div>
        </div>

        <!-- Contact & Learn More -->
        <div class="card">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">
            Learn More
          </h3>
          <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
            Interested in learning more about orchids or joining our community? 
            Connect with the Five Cities Orchid Society and other orchid enthusiasts.
          </p>
          <div class="flex gap-2">
            <button class="btn btn-outline btn-sm" data-action="how-to">
              How to Use
            </button>
            <button class="btn btn-outline btn-sm" data-action="faq">
              FAQ
            </button>
          </div>
        </div>

        <!-- Footer -->
        <div class="text-center text-xs text-gray-500 dark:text-gray-400 py-4 border-t border-gray-200 dark:border-gray-700">
          Five Cities Orchid Society — Learn · Grow · Share<br>
          Educational Widget © ${new Date().getFullYear()}
        </div>
      </div>
    `
  }

  mount(container: HTMLElement): void {
    // Set up event listeners
    const backBtn = container.querySelector('[data-action="back"]')
    const howToBtn = container.querySelector('[data-action="how-to"]')
    const faqBtn = container.querySelector('[data-action="faq"]')
    
    backBtn?.addEventListener('click', () => this.widget.goBack())
    howToBtn?.addEventListener('click', () => this.widget.navigateTo('howto'))
    faqBtn?.addEventListener('click', () => this.widget.navigateTo('faq'))

    // Update AI provider display
    this.updateAIProviderDisplay(container)
  }

  private updateAIProviderDisplay(container: HTMLElement): void {
    const displayEl = container.querySelector('#ai-provider-display')
    const config = this.widget.getConfig()
    
    if (displayEl) {
      displayEl.textContent = config.aiProvider.mode === 'openai' ? 'OpenAI' : 'Custom Webhook'
    }
  }
}